/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.Strings;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.SimplePrincipalSerializer;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.slf4j.Logger;

public class SealedPrincipalSerializer<T extends Principal>
extends SimplePrincipalSerializer<T> {
    @Nonnull
    @NotEmpty
    private static final String PASSWORD_FIELD = "PW";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SealedPrincipalSerializer.class);
    @Nullable
    private DataSealer sealer;

    public SealedPrincipalSerializer(@Nonnull @ParameterName(name="claz") Class<T> claz, @Nonnull @ParameterName(name="name") @NotEmpty String name) throws NoSuchMethodException, SecurityException {
        super(claz, name);
    }

    public void setDataSealer(@Nullable DataSealer theSealer) {
        this.checkSetterPreconditions();
        this.sealer = theSealer;
    }

    @Override
    public boolean supports(@Nonnull Principal principal) {
        this.checkComponentActive();
        if (!super.supports(principal)) {
            return false;
        }
        if (this.sealer == null) {
            this.log.error("No DataSealer was provided, unable to support serialization");
            return false;
        }
        return true;
    }

    @Override
    public boolean supports(@Nonnull @NotEmpty String value) {
        this.checkComponentActive();
        if (!super.supports(value)) {
            return false;
        }
        if (this.sealer == null) {
            this.log.error("No DataSealer was provided, unable to support deserialization");
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    protected String getName(@Nonnull Principal principal) throws IOException {
        this.checkComponentActive();
        try {
            if (this.sealer == null) {
                throw new IOException("No DataSealer was provided, unable to support serialization");
            }
            assert (this.sealer != null);
            return this.sealer.wrap(super.getName(principal));
        }
        catch (DataSealerException e) {
            throw new IOException(e);
        }
    }

    @Override
    @Nullable
    protected String getName(@Nullable String serializedName) throws IOException {
        this.checkComponentActive();
        if (!Strings.isNullOrEmpty((String)serializedName)) {
            try {
                if (this.sealer == null) {
                    throw new IOException("No DataSealer was provided, unable to support serialization");
                }
                assert (this.sealer != null);
                assert (serializedName != null);
                return this.sealer.unwrap(serializedName);
            }
            catch (DataSealerException e) {
                throw new IOException(e);
            }
        }
        return null;
    }
}

