/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;

public class PasswordPrincipal
implements CloneablePrincipal {
    @Nonnull
    @NotEmpty
    private String password;

    public PasswordPrincipal(@Nonnull @ParameterName(name="pw") @NotEmpty String pw) {
        this.password = Constraint.isNotEmpty((String)pw, (String)"Password cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getName() {
        return this.password;
    }

    @Override
    public int hashCode() {
        return this.password.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof PasswordPrincipal) {
            return this.password.equals(((PasswordPrincipal)other).getName());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("password", (Object)"<elided>").toString();
    }

    @Override
    @Nonnull
    public PasswordPrincipal clone() throws CloneNotSupportedException {
        PasswordPrincipal copy = (PasswordPrincipal)super.clone();
        copy.password = this.password;
        return copy;
    }
}

