/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.principal.AuthenticationResultPrincipal;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractAuthenticationResultPredicate
implements Predicate<ProfileRequestContext> {
    private boolean includeIntermediateResults;
    @Nonnull
    private Set<String> includedFlows = CollectionSupport.emptySet();

    public boolean isIncludeIntermediateResults() {
        return this.includeIntermediateResults;
    }

    public void setIncludeIntermediateResults(boolean flag) {
        this.includeIntermediateResults = flag;
    }

    @Nonnull
    public Set<String> getIncludedFlows() {
        return this.includedFlows;
    }

    public void setIncludedFlows(@Nullable Collection<String> flows) {
        this.includedFlows = flows != null ? (Set)((NonnullSupplier)flows.stream().map(s -> "authn/" + s).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get() : CollectionSupport.emptySet();
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return false;
        }
        return this.getAuthenticationResults(input).stream().anyMatch(ar -> {
            assert (ar != null);
            return this.doMatch(input, (AuthenticationResult)ar);
        });
    }

    @Nonnull
    protected Collection<AuthenticationResult> getAuthenticationResults(@Nonnull ProfileRequestContext profileRequestContext) {
        SubjectContext subjectContext;
        AuthenticationContext authContext;
        if (this.includedFlows.isEmpty()) {
            return CollectionSupport.emptyList();
        }
        ArrayList<AuthenticationResult> filtered = new ArrayList<AuthenticationResult>();
        Map<String, AuthenticationResult> results = this.includeIntermediateResults ? ((authContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class)) != null ? authContext.getActiveResults() : CollectionSupport.emptyMap()) : ((subjectContext = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class)) != null ? subjectContext.getAuthenticationResults() : CollectionSupport.emptyMap());
        results.values().forEach(result -> {
            if (this.includedFlows.contains(result.getAuthenticationFlowId())) {
                filtered.add((AuthenticationResult)result);
            }
            Set<AuthenticationResultPrincipal> nested = result.getSubject().getPrincipals(AuthenticationResultPrincipal.class);
            filtered.addAll((Collection)((NonnullSupplier)nested.stream().map(AuthenticationResultPrincipal::getAuthenticationResult).filter(ar -> this.includedFlows.contains(ar.getAuthenticationFlowId())).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get());
        });
        return filtered;
    }

    protected abstract boolean doMatch(@Nonnull ProfileRequestContext var1, @Nonnull AuthenticationResult var2);
}

