/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import org.opensaml.messaging.context.BaseContext;

public final class AuthenticationErrorContext
extends BaseContext {
    @Nonnull
    private List<Exception> exceptions = new ArrayList<Exception>();
    @Nonnull
    private Collection<String> classifiedErrors = new LinkedHashSet<String>();

    @Nonnull
    @Live
    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    @Nonnull
    @Live
    public Collection<String> getClassifiedErrors() {
        return this.classifiedErrors;
    }

    public boolean isClassifiedError(@Nonnull @NotEmpty String error) {
        return this.classifiedErrors.contains(error);
    }

    @Nonnull
    public AuthenticationErrorContext addClassifiedError(@Nonnull @NotEmpty String error) {
        this.classifiedErrors.remove(error);
        this.classifiedErrors.add(error);
        return this;
    }

    @Nullable
    public String getLastClassifiedError() {
        return this.classifiedErrors.stream().reduce((first, second) -> second).orElse(null);
    }
}

