/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.spring.trust;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import org.opensaml.security.x509.X509Support;
import org.opensaml.spring.trust.AbstractBasicPKIXValidationInfoFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.FatalBeanException;

public class PKIXResourceValidationInfoFactoryBean
extends AbstractBasicPKIXValidationInfoFactoryBean {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(PKIXResourceValidationInfoFactoryBean.class);
    @Nullable
    private List<Resource> certificateFiles;
    @Nullable
    private List<Resource> crlFiles;

    public void setCertificates(@Nullable List<Resource> certs) {
        this.certificateFiles = certs;
    }

    public void setCRLs(@Nullable List<Resource> crls) {
        this.crlFiles = crls;
    }

    @Override
    @Nullable
    protected List<X509Certificate> getCertificates() {
        if (null == this.certificateFiles) {
            return null;
        }
        assert (this.certificateFiles != null);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(this.certificateFiles.size());
        assert (this.certificateFiles != null);
        for (Resource f : this.certificateFiles) {
            try {
                InputStream is = f.getInputStream();
                try {
                    certificates.addAll(X509Support.decodeCertificates((InputStream)is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException | CertificateException e) {
                this.log.error("{}: Could not decode Certificate at {}: {}", new Object[]{this.getConfigDescription(), f.getDescription(), e.getMessage()});
                throw new FatalBeanException("Could not decode provided CertificateFile: " + f.getDescription(), (Throwable)e);
            }
        }
        return certificates;
    }

    @Override
    @Nullable
    protected List<X509CRL> getCRLs() {
        if (null == this.crlFiles) {
            return null;
        }
        assert (this.crlFiles != null);
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(this.crlFiles.size());
        assert (this.crlFiles != null);
        for (Resource crlFile : this.crlFiles) {
            try {
                InputStream is = crlFile.getInputStream();
                try {
                    crls.addAll(X509Support.decodeCRLs((InputStream)is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException | CRLException e) {
                this.log.error("{}: Could not decode CRL file at {}: {}", new Object[]{this.getConfigDescription(), crlFile.getDescription(), e.getMessage()});
                throw new FatalBeanException("Could not decode provided CRL file " + crlFile.getDescription(), (Throwable)e);
            }
        }
        return crls;
    }
}

