/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.service.impl;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.service.AbstractReloadableService;
import net.shibboleth.shared.service.LoggingService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LogbackLoggingService
extends AbstractReloadableService<Object>
implements LoggingService,
ApplicationContextAware {
    @NonnullAfterInit
    private LoggerContext loggerContext;
    @NonnullAfterInit
    private StatusManager statusManager;
    @NonnullAfterInit
    private Resource fallbackConfiguration;
    @NonnullAfterInit
    private Resource configurationResource;
    @Nullable
    @NotEmpty
    private String homePropertyName;
    @Nullable
    private ApplicationContext applicationContext;

    @Override
    public void setLoggingConfiguration(@Nonnull Resource configuration) {
        this.checkSetterPreconditions();
        this.configurationResource = (Resource)Constraint.isNotNull((Object)configuration, (String)"Logging configuration resource cannot be null");
    }

    public void setFallbackConfiguration(@Nonnull Resource fallback) {
        this.checkSetterPreconditions();
        this.fallbackConfiguration = (Resource)Constraint.isNotNull((Object)fallback, (String)"Logging configuration falback resource cannot be null");
    }

    public void setHomePropertyName(@Nullable @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.homePropertyName = StringSupport.trimOrNull((String)name);
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) {
        this.applicationContext = context;
    }

    @Override
    @Nonnull
    public ServiceableComponent<Object> getServiceableComponent() {
        throw new ServiceException("LoggingService does not expose a serviceable component");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.configurationResource == null) {
            throw new ComponentInitializationException("Logging configuration must be specified.");
        }
        this.loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.statusManager = this.loggerContext.getStatusManager();
        if (!this.fallbackConfiguration.exists()) {
            if (this.isFailFast()) {
                throw new ComponentInitializationException(this.getLogPrefix() + "Cannot locate fallback configuration");
            }
            this.statusManager.add((Status)new ErrorStatus("Cannot locate fallback configuration at " + this.fallbackConfiguration.getDescription(), (Object)this));
        }
        super.doInitialize();
    }

    @Override
    protected synchronized boolean shouldReload() {
        try {
            Instant lastReload = this.getLastSuccessfulReloadInstant();
            if (null == lastReload) {
                return true;
            }
            return this.configurationResource.lastModified() > lastReload.toEpochMilli();
        }
        catch (IOException e) {
            this.statusManager.add((Status)new ErrorStatus("Error checking last modified time of logging service configuration resource " + this.configurationResource.getDescription(), (Object)this, (Throwable)e));
            return false;
        }
    }

    @Override
    protected synchronized void doReload() {
        this.loadLoggingConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void loadLoggingConfiguration() {
        InputStream ins = null;
        this.statusManager.add((Status)new InfoStatus("Loading new logging configuration resource: " + this.configurationResource.getDescription(), (Object)this));
        ins = this.configurationResource.getInputStream();
        this.loadLoggingConfiguration(ins);
        try {
            Closeables.close((Closeable)ins, (boolean)true);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        catch (Exception e) {
            try {
                try {
                    Closeables.close(ins, (boolean)true);
                }
                catch (IOException e1) {
                    throw new ServiceException(e1);
                }
                this.statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + this.configurationResource.getDescription(), (Object)this, (Throwable)e));
                try {
                    this.statusManager.add((Status)new InfoStatus("Loading fallback logging configuration", (Object)this));
                    ins = this.fallbackConfiguration.getInputStream();
                    this.loadLoggingConfiguration(ins);
                }
                catch (IOException ioe) {
                    try {
                        Closeables.close((Closeable)ins, (boolean)true);
                    }
                    catch (IOException e1) {
                        throw new ServiceException(e1);
                    }
                    this.statusManager.add((Status)new ErrorStatus("Error loading fallback logging configuration", (Object)this, (Throwable)e));
                    throw new ServiceException("Unable to load fallback logging configuration");
                }
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(ins, (boolean)true);
                }
                catch (IOException e2) {
                    throw new ServiceException(e2);
                }
                throw throwable;
            }
            try {
                Closeables.close((Closeable)ins, (boolean)true);
            }
            catch (IOException e3) {
                throw new ServiceException(e3);
            }
        }
    }

    protected void loadLoggingConfiguration(@Nonnull InputStream loggingConfig) {
        try {
            this.loggerContext.reset();
            this.loadHomeProperty();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)this.loggerContext);
            configurator.doConfigure(loggingConfig);
            this.loggerContext.start();
        }
        catch (JoranException e) {
            throw new ServiceException((Exception)((Object)e));
        }
    }

    protected void loadHomeProperty() {
        String home;
        String homePropertyName2 = this.homePropertyName;
        if (this.applicationContext != null && homePropertyName2 != null && (home = this.applicationContext.getEnvironment().getProperty(homePropertyName2)) != null) {
            this.statusManager.add((Status)new InfoStatus("Setting logger property '" + this.homePropertyName + "' to '" + home + "'", (Object)this));
            this.loggerContext.putProperty(this.homePropertyName, home);
        }
    }
}

