/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.saml.ext.saml2mdui.Keywords;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.LocalizedName;
import org.opensaml.saml.saml2.metadata.LocalizedURI;
import org.slf4j.Logger;

public class IdPUIInfo {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(IdPUIInfo.class);
    @Nonnull
    @Unmodifiable
    @NotLive
    private final Map<Locale, String> displayNames;
    @Nonnull
    @Unmodifiable
    @NotLive
    private final Map<Locale, List<String>> keywordList;
    @Nonnull
    @Unmodifiable
    @NotLive
    private final Map<Locale, String> descriptions;
    @Nonnull
    @Unmodifiable
    @NotLive
    private final Map<Locale, List<Logo>> localeLogos;
    @Nonnull
    @Unmodifiable
    @NotLive
    private final List<Logo> nonLocaleLogos;
    @Nonnull
    @Unmodifiable
    @NotLive
    private final Map<Locale, String> informationURLs;
    @Nonnull
    @Unmodifiable
    @NotLive
    private final Map<Locale, String> privacyStatementURLs;
    @Nonnull
    private final Predicate<Keywords> nullLanguageKeyword = new Predicate<Keywords>(){

        @Override
        public boolean test(@Nullable Keywords u) {
            if (u != null && u.getXMLLang() == null) {
                LOG.warn("Keyword with value {} in <UIInfo/> has no language associated, ignoring", (Object)u.getKeywords());
                return false;
            }
            return true;
        }
    };

    public IdPUIInfo(@Nonnull UIInfo uiInfo) {
        this.displayNames = (Map)((NonnullSupplier)uiInfo.getDisplayNames().stream().filter(this.nullLanguageString("DisplayName")).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(displayName -> Locale.forLanguageTag(displayName.getXMLLang()), displayName -> displayName.getValue(), CollectionSupport.warningMergeFunction((String)"IdPUIInfo DisplayName", (boolean)false))))).get();
        this.keywordList = (Map)((NonnullSupplier)uiInfo.getKeywords().stream().filter(this.nullLanguageKeyword).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(keywords -> Locale.forLanguageTag(keywords.getXMLLang()), keywords -> keywords.getKeywords() != null ? keywords.getKeywords() : CollectionSupport.emptyList(), CollectionSupport.warningMergeFunction((String)"IdPUIInfo Keyword", (boolean)false))))).get();
        this.descriptions = (Map)((NonnullSupplier)uiInfo.getDescriptions().stream().filter(this.nullLanguageString("Description")).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(description -> Locale.forLanguageTag(description.getXMLLang()), description -> description.getValue(), CollectionSupport.warningMergeFunction((String)"IdPUIInfo Descriptions", (boolean)false))))).get();
        this.informationURLs = (Map)((NonnullSupplier)uiInfo.getInformationURLs().stream().filter(this.nullLanguageURL("InformationURL")).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(url -> Locale.forLanguageTag(url.getXMLLang()), dn -> dn.getURI(), CollectionSupport.warningMergeFunction((String)"IdPUIInfo InformationURL", (boolean)false))))).get();
        this.privacyStatementURLs = (Map)((NonnullSupplier)uiInfo.getPrivacyStatementURLs().stream().filter(this.nullLanguageURL("PrivacyStatementURL")).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(url -> Locale.forLanguageTag(url.getXMLLang()), url -> url.getURI(), CollectionSupport.warningMergeFunction((String)"IdPUIInfo PrivacyStatementURL", (boolean)false))))).get();
        ArrayList<Logo> noLocaleLogo = new ArrayList<Logo>();
        HashMap withLocaleLogo = new HashMap();
        for (Logo logo : uiInfo.getLogos()) {
            if (logo.getURI() == null) {
                LOG.warn("IdpUIInfo has Logo with null URL, ignoring");
                continue;
            }
            if (logo.getXMLLang() != null) {
                Locale l = Locale.forLanguageTag(logo.getXMLLang());
                if (withLocaleLogo.get(l) == null) {
                    withLocaleLogo.put(l, new ArrayList());
                }
                ((List)withLocaleLogo.get(l)).add(logo);
                continue;
            }
            noLocaleLogo.add(logo);
        }
        this.localeLogos = CollectionSupport.copyToMap(withLocaleLogo);
        this.nonLocaleLogos = CollectionSupport.copyToList(noLocaleLogo);
    }

    @Nonnull
    private final Predicate<LocalizedName> nullLanguageString(final String inside) {
        return new Predicate<LocalizedName>(){

            @Override
            public boolean test(LocalizedName u) {
                if (u.getXMLLang() == null) {
                    LOG.warn("String with value {} in <{}/> has no language associated, ignoring", (Object)u.getValue(), (Object)inside);
                    return false;
                }
                if (u.getValue() == null) {
                    LOG.warn("Ignoring empty string in <{}/>", (Object)inside);
                    return false;
                }
                return true;
            }
        };
    }

    @Nonnull
    private final Predicate<LocalizedURI> nullLanguageURL(final @Nonnull String inside) {
        return new Predicate<LocalizedURI>(){

            @Override
            public boolean test(LocalizedURI u) {
                if (u.getXMLLang() == null) {
                    LOG.warn("URI with value {} in <{}/> has no language associated, ignoring", (Object)u.getURI(), (Object)inside);
                    return false;
                }
                if (u.getURI() == null) {
                    LOG.warn("Ignoring empty URI in <{}/>", (Object)inside);
                    return false;
                }
                return true;
            }
        };
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Locale, String> getDisplayNames() {
        return this.displayNames;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Locale, List<String>> getKeywords() {
        return this.keywordList;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Locale, String> getDescriptions() {
        return this.descriptions;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Locale, List<Logo>> getLocaleLogos() {
        return this.localeLogos;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<Logo> getNonLocaleLogos() {
        return this.nonLocaleLogos;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Locale, String> getInformationURLs() {
        return this.informationURLs;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Locale, String> getPrivacyStatementURLs() {
        return this.privacyStatementURLs;
    }
}

