/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.impl;

import java.security.Principal;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.logic.ProxyAwareForceAuthnPredicate;
import net.shibboleth.idp.saml.saml2.profile.config.impl.AbstractSAML2AssertionProducingProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.navigate.ProxyAwareAuthnContextComparisonLookupFunction;
import net.shibboleth.idp.saml.saml2.profile.config.navigate.ProxyAwareDefaultAuthenticationMethodsLookupFunction;
import net.shibboleth.shared.annotation.ConfigurationSetting;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;

public class BrowserSSOProfileConfiguration
extends AbstractSAML2AssertionProducingProfileConfiguration
implements AuthenticationProfileConfiguration,
net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.saml2.sso.browser";
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> requestedIdPAttributeNamesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> attributeRecipientGroupIDLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> includeAttributeStatementPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> ignoreScoping;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Duration> maxAgeLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> checkAddressPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> checkInResponseToPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> skipEndpointValidationWhenSignedPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> randomizeFriendlyNamePredicate;
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> proxyAudiencesLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> proxiedAuthnInstantPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> suppressAuthenticatingAuthorityPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> requireSignedRequestsPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> requireSignedAssertionsPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Duration> maximumSPSessionLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> maximumTimeSinceAuthnLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> allowDelegationPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Long> maximumTokenDelegationChainLengthLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Function<AuthnContext, Collection<Principal>>> authnContextTranslationStrategyLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Function<ProfileRequestContext, Collection<Principal>>> authnContextTranslationStrategyExLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> authnContextComparisonLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<Principal>> defaultAuthenticationContextsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> nameIDFormatPrecedenceLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> spNameQualifierLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Integer> attributeIndexLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<RequestedAttribute>> requestedAttributesLookupStrategy;

    public BrowserSSOProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml2/sso/browser");
    }

    protected BrowserSSOProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponses(true);
        this.setEncryptAssertions(true);
        this.resolveAttributesPredicate = PredicateSupport.alwaysTrue();
        this.requestedIdPAttributeNamesLookupStrategy = FunctionSupport.constant(null);
        this.attributeRecipientGroupIDLookupStrategy = FunctionSupport.constant(null);
        this.includeAttributeStatementPredicate = PredicateSupport.alwaysTrue();
        this.ignoreScoping = PredicateSupport.alwaysFalse();
        this.forceAuthnPredicate = new ProxyAwareForceAuthnPredicate();
        this.maxAgeLookupStrategy = FunctionSupport.constant(null);
        this.checkAddressPredicate = PredicateSupport.alwaysTrue();
        this.checkInResponseToPredicate = PredicateSupport.alwaysTrue();
        this.skipEndpointValidationWhenSignedPredicate = PredicateSupport.alwaysFalse();
        this.randomizeFriendlyNamePredicate = PredicateSupport.alwaysFalse();
        this.proxyCountLookupStrategy = FunctionSupport.constant(null);
        this.proxyAudiencesLookupStrategy = FunctionSupport.constant(null);
        this.proxiedAuthnInstantPredicate = PredicateSupport.alwaysTrue();
        this.suppressAuthenticatingAuthorityPredicate = PredicateSupport.alwaysFalse();
        this.requireSignedRequestsPredicate = PredicateSupport.alwaysFalse();
        this.requireSignedAssertionsPredicate = PredicateSupport.alwaysFalse();
        this.maximumSPSessionLifetimeLookupStrategy = FunctionSupport.constant(null);
        this.maximumTimeSinceAuthnLookupStrategy = FunctionSupport.constant(null);
        this.maximumTokenDelegationChainLengthLookupStrategy = FunctionSupport.constant((Object)DEFAULT_DELEGATION_CHAIN_LENGTH);
        this.allowDelegationPredicate = PredicateSupport.alwaysFalse();
        this.authenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.postAuthenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.authnContextTranslationStrategyLookupStrategy = FunctionSupport.constant(null);
        this.authnContextTranslationStrategyExLookupStrategy = FunctionSupport.constant(null);
        this.authnContextComparisonLookupStrategy = new ProxyAwareAuthnContextComparisonLookupFunction();
        this.defaultAuthenticationContextsLookupStrategy = new ProxyAwareDefaultAuthenticationMethodsLookupFunction();
        this.nameIDFormatPrecedenceLookupStrategy = FunctionSupport.constant(null);
        this.spNameQualifierLookupStrategy = FunctionSupport.constant(null);
        this.attributeIndexLookupStrategy = FunctionSupport.constant(null);
        this.requestedAttributesLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<String> getRequestedIdPAttributeNames(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> names = this.requestedIdPAttributeNamesLookupStrategy.apply(profileRequestContext);
        if (names != null) {
            return CollectionSupport.copyToSet(names);
        }
        return CollectionSupport.emptySet();
    }

    public void setRequestedIdPAttributeNames(@Nullable Collection<String> names) {
        this.requestedIdPAttributeNamesLookupStrategy = names == null || names.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant((Object)CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(names)));
    }

    public void setRequestedIdPAttributeNamesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.requestedIdPAttributeNamesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Requested IdPAttribute names lookup strategy cannot be null");
    }

    @Nullable
    public String getAttributeRecipientGroupID(@Nullable ProfileRequestContext profileRequestContext) {
        return this.attributeRecipientGroupIDLookupStrategy.apply(profileRequestContext);
    }

    public void setAttributeRecipientGroupID(@Nullable String groupID) {
        this.attributeRecipientGroupIDLookupStrategy = FunctionSupport.constant((Object)groupID);
    }

    public void setAttributeRecipientGroupIDLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.attributeRecipientGroupIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Group ID lookup strategy cannot be null");
    }

    public boolean isIncludeAttributeStatement(@Nullable ProfileRequestContext profileRequestContext) {
        return this.includeAttributeStatementPredicate.test(profileRequestContext);
    }

    public void setIncludeAttributeStatement(boolean flag) {
        this.includeAttributeStatementPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setIncludeAttributeStatementPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.includeAttributeStatementPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Include attribute statement predicate cannot be null");
    }

    public boolean isIgnoreScoping(@Nullable ProfileRequestContext profileRequestContext) {
        return this.ignoreScoping.test(profileRequestContext);
    }

    public void setIgnoreScoping(boolean flag) {
        this.ignoreScoping = PredicateSupport.constant((boolean)flag);
    }

    public void setIgnoreScopingPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ignoreScoping = (Predicate)Constraint.isNotNull(condition, (String)"Ignore Scoping condition cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    @ConfigurationSetting(name="maxAge")
    @Nullable
    public Duration getMaxAge(@Nullable ProfileRequestContext profileRequestContext) {
        return this.maxAgeLookupStrategy.apply(profileRequestContext);
    }

    public void setMaxAge(@Nullable Duration maxAge) {
        this.maxAgeLookupStrategy = FunctionSupport.constant((Object)maxAge);
    }

    public void setMaxAgeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.maxAgeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isCheckAddress(@Nullable ProfileRequestContext profileRequestContext) {
        return this.checkAddressPredicate.test(profileRequestContext);
    }

    public void setCheckAddress(boolean flag) {
        this.checkAddressPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setCheckAddressPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkAddressPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Address checking predicate cannot be null");
    }

    public boolean isCheckInResponseTo(@Nullable ProfileRequestContext profileRequestContext) {
        return this.checkInResponseToPredicate.test(profileRequestContext);
    }

    public void setCheckInResponseTo(boolean flag) {
        this.checkInResponseToPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setCheckInResponseToPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkInResponseToPredicate = (Predicate)Constraint.isNotNull(condition, (String)"InResponseTo checking predicate cannot be null");
    }

    public boolean isSkipEndpointValidationWhenSigned(@Nullable ProfileRequestContext profileRequestContext) {
        return this.skipEndpointValidationWhenSignedPredicate.test(profileRequestContext);
    }

    public void setSkipEndpointValidationWhenSigned(boolean flag) {
        this.skipEndpointValidationWhenSignedPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSkipEndpointValidationWhenSignedPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.skipEndpointValidationWhenSignedPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isRandomizeFriendlyName(@Nullable ProfileRequestContext profileRequestContext) {
        return this.randomizeFriendlyNamePredicate.test(profileRequestContext);
    }

    public void setRandomizeFriendlyName(boolean flag) {
        this.randomizeFriendlyNamePredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setRandomizeFriendlyNamePredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.randomizeFriendlyNamePredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nullable
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getProxyAudiences(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> audiences = this.proxyAudiencesLookupStrategy.apply(profileRequestContext);
        if (audiences != null) {
            return CollectionSupport.copyToSet(audiences);
        }
        return CollectionSupport.emptySet();
    }

    public void setProxyAudiences(@Nullable Collection<String> audiences) {
        this.proxyAudiencesLookupStrategy = audiences == null || audiences.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant((Object)CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(audiences)));
    }

    public void setProxyAudiencesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.proxyAudiencesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isSuppressAuthenticatingAuthority(@Nullable ProfileRequestContext profileRequestContext) {
        return this.suppressAuthenticatingAuthorityPredicate.test(profileRequestContext);
    }

    public void setSuppressAuthenticatingAuthority(boolean flag) {
        this.suppressAuthenticatingAuthorityPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSuppressAuthenticatingAuthorityPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.suppressAuthenticatingAuthorityPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isProxiedAuthnInstant(@Nullable ProfileRequestContext profileRequestContext) {
        return this.proxiedAuthnInstantPredicate.test(profileRequestContext);
    }

    public void setProxiedAuthnInstant(boolean flag) {
        this.proxiedAuthnInstantPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setProxiedAuthnInstantPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.proxiedAuthnInstantPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isRequireSignedRequests(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requireSignedRequestsPredicate.test(profileRequestContext);
    }

    public void setRequireSignedRequests(boolean flag) {
        this.requireSignedRequestsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setRequireSignedRequestsPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.requireSignedRequestsPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Signed requests predicate cannot be null");
    }

    public boolean isRequireSignedAssertions(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requireSignedAssertionsPredicate.test(profileRequestContext);
    }

    public void setRequireSignedAssertions(boolean flag) {
        this.requireSignedAssertionsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setRequireSignedAssertionsPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.requireSignedAssertionsPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Signed assertions predicate cannot be null");
    }

    @Nullable
    public Duration getMaximumSPSessionLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.maximumSPSessionLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((lifetime != null && lifetime.isNegative() ? 1 : 0) != 0, (String)"Maximum SP session lifetime must be greater than or equal to 0");
        return lifetime;
    }

    public void setMaximumSPSessionLifetime(@Nullable Duration lifetime) {
        Constraint.isFalse((lifetime != null && lifetime.isNegative() ? 1 : 0) != 0, (String)"Maximum SP session lifetime must be greater than or equal to 0");
        this.maximumSPSessionLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setMaximumSPSessionLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.maximumSPSessionLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    @NonNegative
    public Duration getMaximumTimeSinceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        Duration amount = this.maximumTimeSinceAuthnLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((amount != null && amount.isNegative() ? 1 : 0) != 0, (String)"Maximum time since authentication must be greater than or equal to 0");
        return amount;
    }

    public void setMaximumTimeSinceAuthn(@Nullable Duration amount) {
        Constraint.isFalse((amount != null && amount.isNegative() ? 1 : 0) != 0, (String)"Maximum time since authentication must be greater than or equal to 0");
        this.maximumTimeSinceAuthnLookupStrategy = FunctionSupport.constant((Object)amount);
    }

    public void setMaximumTimeSinceAuthnLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.maximumTimeSinceAuthnLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public boolean isAllowDelegation(@Nullable ProfileRequestContext profileRequestContext) {
        return this.allowDelegationPredicate.test(profileRequestContext);
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public void setAllowDelegation(boolean flag) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"allowDelegation", (String)"relying-party.xml", null);
        this.allowDelegationPredicate = PredicateSupport.constant((boolean)flag);
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public void setAllowDelegationPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"allowDelegationPredicate", (String)"relying-party.xml", null);
        this.allowDelegationPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Allow delegation predicate cannot be null");
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @NonNegative
    public long getMaximumTokenDelegationChainLength(@Nullable ProfileRequestContext profileRequestContext) {
        Long len = this.maximumTokenDelegationChainLengthLookupStrategy.apply(profileRequestContext);
        Constraint.isNotNull((Object)len, (String)"Delegation chain length cannot be null");
        Constraint.isGreaterThanOrEqual((long)0L, (long)len, (String)"Delegation chain length must be greater than or equal to 0");
        return len;
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public void setMaximumTokenDelegationChainLength(@NonNegative long length) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"maximumTokenDelegationChainLength", (String)"relying-party.xml", null);
        Constraint.isGreaterThanOrEqual((long)0L, (long)length, (String)"Delegation chain length must be greater than or equal to 0");
        this.maximumTokenDelegationChainLengthLookupStrategy = FunctionSupport.constant((Object)length);
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public void setMaximumTokenDelegationChainLengthLookupStrategy(@Nonnull Function<ProfileRequestContext, Long> strategy) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"maximumTokenDelegationChainLengthLookupStrategy", (String)"relying-party.xml", null);
        this.maximumTokenDelegationChainLengthLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Function<AuthnContext, Collection<Principal>> getAuthnContextTranslationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.authnContextTranslationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setAuthnContextTranslationStrategy(@Nullable Function<AuthnContext, Collection<Principal>> strategy) {
        this.authnContextTranslationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setAuthnContextTranslationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, Function<AuthnContext, Collection<Principal>>> strategy) {
        this.authnContextTranslationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Function<ProfileRequestContext, Collection<Principal>> getAuthnContextTranslationStrategyEx(@Nullable ProfileRequestContext profileRequestContext) {
        return this.authnContextTranslationStrategyExLookupStrategy.apply(profileRequestContext);
    }

    public void setAuthnContextTranslationStrategyEx(@Nullable Function<ProfileRequestContext, Collection<Principal>> strategy) {
        this.authnContextTranslationStrategyExLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setAuthnContextTranslationStrategyExLookupStrategy(@Nonnull Function<ProfileRequestContext, Function<ProfileRequestContext, Collection<Principal>>> strategy) {
        this.authnContextTranslationStrategyExLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public AuthnContextComparisonTypeEnumeration getAuthnContextComparison(@Nullable ProfileRequestContext profileRequestContext) {
        String comparison = this.authnContextComparisonLookupStrategy.apply(profileRequestContext);
        if (comparison != null) {
            return AuthnContextComparisonTypeEnumeration.valueOf((String)comparison.toUpperCase());
        }
        return null;
    }

    public void setAuthnContextComparison(@Nullable AuthnContextComparisonTypeEnumeration comparison) {
        this.authnContextComparisonLookupStrategy = FunctionSupport.constant((Object)(comparison != null ? comparison.toString() : null));
    }

    public void setAuthnContextComparisonLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.authnContextComparisonLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<Principal> methods = this.defaultAuthenticationContextsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return CollectionSupport.copyToList(methods);
        }
        return CollectionSupport.emptyList();
    }

    public void setDefaultAuthenticationMethods(@Nullable Collection<Principal> contexts) {
        this.defaultAuthenticationContextsLookupStrategy = contexts != null ? FunctionSupport.constant(List.copyOf(contexts)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<Principal>> strategy) {
        this.defaultAuthenticationContextsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> flows = this.authenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToSet(flows);
        }
        return CollectionSupport.emptySet();
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    public void setAuthenticationFlows(@Nullable Collection<String> flows) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"setAuthenticationFlows", (String)"relying-party.xml", (String)"setDefaultAuthenticationMethods");
        this.authenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant((Object)CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    public void setAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"setAuthenticationFlowsLookupStrategy", (String)"relying-party.xml", (String)"setDefaultAuthenticationMethodsLookupStrategy");
        this.authenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> flows = this.postAuthenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToList(flows);
        }
        return CollectionSupport.emptyList();
    }

    public void setPostAuthenticationFlows(@Nullable Collection<String> flows) {
        this.postAuthenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> formats = this.nameIDFormatPrecedenceLookupStrategy.apply(profileRequestContext);
        if (formats != null) {
            return CollectionSupport.copyToList(formats);
        }
        return CollectionSupport.emptyList();
    }

    public void setNameIDFormatPrecedence(@Nullable Collection<String> formats) {
        this.nameIDFormatPrecedenceLookupStrategy = formats != null ? FunctionSupport.constant((Object)CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(formats))) : FunctionSupport.constant(null);
    }

    public void setNameIDFormatPrecedenceLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.nameIDFormatPrecedenceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public String getSPNameQualifier(@Nullable ProfileRequestContext profileRequestContext) {
        return this.spNameQualifierLookupStrategy.apply(profileRequestContext);
    }

    public void setSPNameQualifier(@Nullable String qualifier) {
        this.spNameQualifierLookupStrategy = FunctionSupport.constant((Object)qualifier);
    }

    public void setSPNameQualifierLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.spNameQualifierLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Integer getAttributeIndex(@Nullable ProfileRequestContext profileRequestContext) {
        return this.attributeIndexLookupStrategy.apply(profileRequestContext);
    }

    public void setAttributeIndex(@Nullable Integer index) {
        this.attributeIndexLookupStrategy = FunctionSupport.constant((Object)index);
    }

    public void setAttributeIndexLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.attributeIndexLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<RequestedAttribute> getRequestedAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<RequestedAttribute> attrs = this.requestedAttributesLookupStrategy.apply(profileRequestContext);
        if (attrs != null) {
            return CollectionSupport.copyToList(attrs);
        }
        return CollectionSupport.emptyList();
    }

    public void setRequestedAttributes(@Nullable Collection<RequestedAttribute> attrs) {
        this.requestedAttributesLookupStrategy = attrs != null ? FunctionSupport.constant((Object)CollectionSupport.copyToList(attrs)) : FunctionSupport.constant(null);
    }

    public void setRequestedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<RequestedAttribute>> strategy) {
        this.requestedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

