/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.impl;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.impl.AbstractSAML2AssertionProducingProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.logic.NoIntegrityMessageChannelPredicate;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoConfidentialityMessageChannelPredicate;

public class AttributeQueryProfileConfiguration
extends AbstractSAML2AssertionProducingProfileConfiguration
implements net.shibboleth.idp.saml.saml2.profile.config.AttributeQueryProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.sam2.query.attribute";
    @Nonnull
    private Predicate<ProfileRequestContext> randomizeFriendlyNamePredicate;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> requestedIdPAttributeNamesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> attributeRecipientGroupIDLookupStrategy;
    @Nonnull
    private Predicate<MessageContext> signSOAPRequestsPredicate;
    @Nonnull
    private Predicate<MessageContext> clientTLSSOAPRequestsPredicate;

    public AttributeQueryProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml2/query/attribute");
    }

    protected AttributeQueryProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponsesPredicate((Predicate<ProfileRequestContext>)new org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate());
        this.setEncryptAssertionsPredicate((Predicate<ProfileRequestContext>)new NoConfidentialityMessageChannelPredicate());
        this.randomizeFriendlyNamePredicate = PredicateSupport.alwaysFalse();
        this.requestedIdPAttributeNamesLookupStrategy = FunctionSupport.constant(null);
        this.attributeRecipientGroupIDLookupStrategy = FunctionSupport.constant(null);
        this.signSOAPRequestsPredicate = new NoIntegrityMessageChannelPredicate();
        Predicate cltsrp = new NoIntegrityMessageChannelPredicate().negate();
        assert (cltsrp != null);
        this.clientTLSSOAPRequestsPredicate = cltsrp;
    }

    public boolean isRandomizeFriendlyName(@Nullable ProfileRequestContext profileRequestContext) {
        return this.randomizeFriendlyNamePredicate.test(profileRequestContext);
    }

    public void setRandomizeFriendlyName(boolean flag) {
        this.randomizeFriendlyNamePredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setRandomizeFriendlyNamePredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.randomizeFriendlyNamePredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return true;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<String> getRequestedIdPAttributeNames(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> names = this.requestedIdPAttributeNamesLookupStrategy.apply(profileRequestContext);
        if (names != null) {
            return CollectionSupport.copyToSet(names);
        }
        return CollectionSupport.emptySet();
    }

    public void setRequestedIdPAttributeNames(@Nullable Collection<String> names) {
        this.requestedIdPAttributeNamesLookupStrategy = names == null || names.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant((Object)CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(names)));
    }

    public void setRequestedIdPAttributeNamesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.requestedIdPAttributeNamesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Requested IdPAttribute names lookup strategy cannot be null");
    }

    @Nullable
    public String getAttributeRecipientGroupID(@Nullable ProfileRequestContext profileRequestContext) {
        return this.attributeRecipientGroupIDLookupStrategy.apply(profileRequestContext);
    }

    public void setAttributeRecipientGroupID(@Nullable String groupID) {
        this.attributeRecipientGroupIDLookupStrategy = FunctionSupport.constant((Object)groupID);
    }

    public void setAttributeRecipientGroupIDLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.attributeRecipientGroupIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Group ID lookup strategy cannot be null");
    }

    public boolean isSignSOAPRequests(@Nullable MessageContext messageContext) {
        return this.signSOAPRequestsPredicate.test(messageContext);
    }

    public void setSignSOAPRequests(boolean flag) {
        this.signSOAPRequestsPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setSignSOAPRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.signSOAPRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine SOAP-based signing cannot be null");
    }

    public boolean isClientTLSSOAPRequests(@Nullable MessageContext messageContext) {
        return this.clientTLSSOAPRequestsPredicate.test(messageContext);
    }

    public void setClientTLSSOAPRequests(boolean flag) {
        this.clientTLSSOAPRequestsPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setClientTLSSOAPRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.clientTLSSOAPRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine SOAP-based client TLS use cannot be null");
    }
}

