/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import java.security.Principal;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.impl.DefaultPrincipalDeterminationStrategy;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.profile.impl.BaseAddAuthenticationStatementToAssertion;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.SubjectLocality;
import org.opensaml.saml.saml1.profile.SAML1ActionSupport;
import org.slf4j.Logger;

public class AddAuthenticationStatementToAssertion
extends BaseAddAuthenticationStatementToAssertion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAuthenticationStatementToAssertion.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, Assertion> assertionLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, AuthenticationMethodPrincipal> methodLookupStrategy;

    public void setAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        this.checkSetterPreconditions();
        this.assertionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion lookup strategy cannot be null");
    }

    public void setAuthenticationMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthenticationMethodPrincipal> strategy) {
        this.checkSetterPreconditions();
        this.methodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication method strategy cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.methodLookupStrategy == null) {
            this.methodLookupStrategy = new DefaultPrincipalDeterminationStrategy(AuthenticationMethodPrincipal.class, (Principal)new AuthenticationMethodPrincipal("urn:oasis:names:tc:SAML:1.0:am:unspecified"));
        }
        if (this.assertionLookupStrategy == null) {
            this.assertionLookupStrategy = new AssertionStrategy();
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Assertion assertion = this.assertionLookupStrategy.apply(profileRequestContext);
        if (assertion == null) {
            this.log.error("Unable to obtain Assertion to modify");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        AuthenticationStatement statement = this.buildAuthenticationStatement(profileRequestContext, (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class));
        assertion.getAuthenticationStatements().add(statement);
        this.log.debug("{} Added AuthenticationStatement to Assertion {}", (Object)this.getLogPrefix(), (Object)assertion.getID());
    }

    @Nonnull
    private AuthenticationStatement buildAuthenticationStatement(@Nonnull ProfileRequestContext profileRequestContext, @Nullable RequestedPrincipalContext requestedPrincipalContext) {
        Principal matchingPrincipal;
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)bf.ensureBuilder(AuthenticationStatement.TYPE_NAME);
        SAMLObjectBuilder localityBuilder = (SAMLObjectBuilder)bf.ensureBuilder(SubjectLocality.TYPE_NAME);
        AuthenticationStatement statement = (AuthenticationStatement)statementBuilder.buildObject();
        statement.setAuthenticationInstant(this.getAuthenticationResult().getAuthenticationInstant());
        Principal principal = matchingPrincipal = requestedPrincipalContext != null ? requestedPrincipalContext.getMatchingPrincipal() : null;
        if (matchingPrincipal != null && matchingPrincipal instanceof AuthenticationMethodPrincipal) {
            statement.setAuthenticationMethod(matchingPrincipal.getName());
        } else {
            statement.setAuthenticationMethod(this.methodLookupStrategy.apply(profileRequestContext).getName());
        }
        String address = this.getAddressLookupStrategy().apply(profileRequestContext);
        if (address != null) {
            SubjectLocality locality = (SubjectLocality)localityBuilder.buildObject();
            locality.setIPAddress(address);
            statement.setSubjectLocality(locality);
        } else {
            this.log.debug("{} Address not available, omitting SubjectLocality element", (Object)this.getLogPrefix());
        }
        return statement;
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, Assertion> {
        private AssertionStrategy() {
        }

        @Override
        @Nullable
        public Assertion apply(@Nullable ProfileRequestContext input) {
            MessageContext omc;
            MessageContext messageContext = omc = input == null ? null : input.getOutboundMessageContext();
            if (input != null && omc != null) {
                Object outboundMessage = omc.getMessage();
                if (outboundMessage == null) {
                    Assertion ret = SAML1ActionSupport.buildAssertion((AbstractProfileAction)AddAuthenticationStatementToAssertion.this, (IdentifierGenerationStrategy)AddAuthenticationStatementToAssertion.this.getIdGenerator(), (String)AddAuthenticationStatementToAssertion.this.getIssuerId());
                    omc.setMessage((Object)ret);
                    return ret;
                }
                if (outboundMessage instanceof Assertion) {
                    return (Assertion)outboundMessage;
                }
                if (outboundMessage instanceof Response) {
                    if (AddAuthenticationStatementToAssertion.this.isStatementInOwnAssertion() || ((Response)outboundMessage).getAssertions().isEmpty()) {
                        return SAML1ActionSupport.addAssertionToResponse((AbstractProfileAction)AddAuthenticationStatementToAssertion.this, (Response)((Response)outboundMessage), (IdentifierGenerationStrategy)AddAuthenticationStatementToAssertion.this.getIdGenerator(), (String)AddAuthenticationStatementToAssertion.this.getIssuerId());
                    }
                    return (Assertion)((Response)outboundMessage).getAssertions().get(0);
                }
            }
            return null;
        }
    }
}

