/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;

public class InitializeOutboundMessageContextForError
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOutboundMessageContextForError.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLBindingContext> bindingContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @NonnullAfterInit
    private BindingDescriptor outboundBinding;
    @Nullable
    private SAMLPeerEntityContext peerEntityCtx;

    public InitializeOutboundMessageContextForError() {
        Function bcs = new ChildContextLookup(SAMLBindingContext.class, true).compose((Function)new OutboundMessageContextLookup());
        assert (bcs != null);
        this.bindingContextLookupStrategy = bcs;
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setBindingContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLBindingContext> strategy) {
        this.checkSetterPreconditions();
        this.bindingContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLBindingContext lookup strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setOutboundBinding(@Nonnull @NotEmpty BindingDescriptor binding) {
        this.outboundBinding = (BindingDescriptor)Constraint.isNotNull((Object)binding, (String)"Outbound BindingDescriptor cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.outboundBinding == null) {
            throw new ComponentInitializationException("Outbound BindingDescriptor cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        BaseContext identifyingCtx;
        if (profileRequestContext.getOutboundMessageContext() != null) {
            this.log.debug("{} Outbound message context already exists, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        RelyingPartyContext relyingPartyCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (relyingPartyCtx != null && (identifyingCtx = relyingPartyCtx.getRelyingPartyIdContextTree()) != null && identifyingCtx instanceof SAMLPeerEntityContext) {
            this.peerEntityCtx = (SAMLPeerEntityContext)identifyingCtx;
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgCtx = new MessageContext();
        profileRequestContext.setOutboundMessageContext(msgCtx);
        SAMLBindingContext bindingCtx = this.bindingContextLookupStrategy.apply(profileRequestContext);
        if (bindingCtx == null) {
            this.log.error("{} Unable to locate/create SAMLBindingContext to populate", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        MessageContext inboundMessageContext = profileRequestContext.getInboundMessageContext();
        if (inboundMessageContext != null) {
            bindingCtx.setRelayState(SAMLBindingSupport.getRelayState((MessageContext)inboundMessageContext));
        }
        bindingCtx.setBindingDescriptor(this.outboundBinding);
        if (this.peerEntityCtx != null) {
            SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)msgCtx.ensureSubcontext(SAMLPeerEntityContext.class);
            SAMLPeerEntityContext pec = this.peerEntityCtx;
            assert (pec != null);
            peerContext.setEntityId(pec.getEntityId());
            SAMLMetadataContext inboundMetadataCtx = (SAMLMetadataContext)pec.getSubcontext(SAMLMetadataContext.class);
            if (inboundMetadataCtx != null) {
                SAMLMetadataContext outboundMetadataCtx = (SAMLMetadataContext)peerContext.ensureSubcontext(SAMLMetadataContext.class);
                outboundMetadataCtx.setEntityDescriptor(inboundMetadataCtx.getEntityDescriptor());
                outboundMetadataCtx.setRoleDescriptor(inboundMetadataCtx.getRoleDescriptor());
            }
        }
        this.log.debug("{} Initialized outbound message context for error delivery", (Object)this.getLogPrefix());
    }
}

