/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.messaging.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SAML2AuthnRequestsSignedSecurityHandler
extends org.opensaml.saml.saml2.binding.security.impl.SAML2AuthnRequestsSignedSecurityHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2AuthnRequestsSignedSecurityHandler.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    protected boolean isRequestSigningRequired(@Nonnull MessageContext messageContext) {
        RelyingPartyContext rpCtx;
        ProfileConfiguration profileConfiguration;
        if (super.isRequestSigningRequired(messageContext)) {
            return true;
        }
        if (messageContext.getParent() instanceof ProfileRequestContext && (profileConfiguration = (rpCtx = this.relyingPartyContextLookupStrategy.apply((ProfileRequestContext)messageContext.getParent())).getProfileConfig()) instanceof BrowserSSOProfileConfiguration) {
            BrowserSSOProfileConfiguration sso = (BrowserSSOProfileConfiguration)profileConfiguration;
            return sso.isRequireSignedRequests((ProfileRequestContext)messageContext.getParent());
        }
        this.log.warn("Unable to locate profile configuration in context tree");
        return false;
    }
}

