/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.condition;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ApiVersionHolder;
import org.springframework.web.accept.ApiVersionStrategy;
import org.springframework.web.accept.NotAcceptableApiVersionException;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;

public final class VersionRequestCondition
extends AbstractRequestCondition<VersionRequestCondition> {
    private final @Nullable String versionValue;
    private final @Nullable Comparable<?> version;
    private final boolean baselineVersion;
    private final Set<String> content;

    public VersionRequestCondition(@Nullable String version, @Nullable ApiVersionStrategy strategy) {
        if (StringUtils.hasText((String)version)) {
            Assert.isTrue((strategy != null ? 1 : 0) != 0, (String)"ApiVersionStrategy is required for mapping by version");
            this.baselineVersion = version.endsWith("+");
            this.versionValue = VersionRequestCondition.updateVersion(version, this.baselineVersion);
            this.version = strategy.parseVersion(this.versionValue);
            this.content = Set.of(version);
        } else {
            this.versionValue = null;
            this.version = null;
            this.baselineVersion = false;
            this.content = Collections.emptySet();
        }
    }

    private static String updateVersion(String version, boolean baselineVersion) {
        return baselineVersion ? version.substring(0, version.length() - 1) : version;
    }

    @Override
    protected Collection<String> getContent() {
        return this.content;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    public @Nullable String getVersion() {
        return this.versionValue;
    }

    @Override
    public VersionRequestCondition combine(VersionRequestCondition other) {
        return other.version != null ? other : this;
    }

    @Override
    public @Nullable VersionRequestCondition getMatchingCondition(HttpServletRequest request) {
        ApiVersionHolder versionHolder = (ApiVersionHolder)request.getAttribute(HandlerMapping.API_VERSION_ATTRIBUTE);
        if (this.version == null || !versionHolder.hasVersion()) {
            return this;
        }
        Comparable requestVersion = versionHolder.getVersion();
        int result = this.compareVersions(this.version, requestVersion);
        return result <= 0 ? this : null;
    }

    private <V extends Comparable<V>> int compareVersions(Object v1, Object v2) {
        return ((Comparable)v1).compareTo((Comparable)v2);
    }

    @Override
    public int compareTo(VersionRequestCondition other, HttpServletRequest request) {
        Comparable<?> otherVersion = other.version;
        if (this.version == null && otherVersion == null) {
            return 0;
        }
        if (this.version != null && otherVersion != null) {
            return -1 * this.compareVersions(this.version, otherVersion);
        }
        int result = this.version != null ? -1 : 1;
        ApiVersionHolder holder = (ApiVersionHolder)request.getAttribute(HandlerMapping.API_VERSION_ATTRIBUTE);
        return !holder.hasVersion() ? -1 * result : result;
    }

    public void handleMatch(HttpServletRequest request) {
        ApiVersionHolder holder;
        Comparable version;
        if (this.version != null && !this.baselineVersion && (version = (holder = (ApiVersionHolder)request.getAttribute(HandlerMapping.API_VERSION_ATTRIBUTE)).getVersionIfPresent()) != null && !this.version.equals(version)) {
            throw new NotAcceptableApiVersionException(version.toString());
        }
    }
}

