/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.AbstractProtocolResponse;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProxyTicketRequest;
import net.shibboleth.idp.cas.protocol.ProxyTicketResponse;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PopulateProtocolErrorAction<RequestType>
extends AbstractCASProtocolAction<RequestType, AbstractProtocolResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateProtocolErrorAction.class);

    @Nullable
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        ProxyTicketResponse response;
        Object request;
        try {
            request = this.getCASRequest(profileRequestContext);
        }
        catch (EventException e) {
            return ActionSupport.buildEvent((Object)((Object)this), (String)e.getEventID());
        }
        if (request instanceof ProxyTicketRequest) {
            response = new ProxyTicketResponse();
        } else if (request instanceof TicketValidationRequest) {
            response = new TicketValidationResponse();
        } else {
            this.log.error("{} Invalid request type: {}", (Object)this.getLogPrefix(), request);
            return ActionSupport.buildEvent((Object)((Object)this), (String)"InvalidMessage");
        }
        String code = (String)springRequestContext.getCurrentEvent().getAttributes().get("code");
        String detail = (String)springRequestContext.getCurrentEvent().getAttributes().get("detailCode");
        if (code == null) {
            code = ProtocolError.IllegalState.getCode();
        }
        if (detail == null) {
            detail = ProtocolError.IllegalState.getDetailCode();
        }
        response.setErrorCode(code);
        response.setErrorDetail(detail);
        try {
            this.setCASResponse(profileRequestContext, response);
        }
        catch (EventException e) {
            return ActionSupport.buildEvent((Object)((Object)this), (String)e.getEventID());
        }
        return ActionSupport.buildProceedEvent((Object)((Object)this));
    }
}

