/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class BuildProxyChainAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildProxyChainAction.class);
    @Nonnull
    private final TicketService casTicketService;
    @NonnullBeforeExec
    private TicketValidationResponse response;
    @NonnullBeforeExec
    private Ticket ticket;

    public BuildProxyChainAction(@Nonnull TicketService ticketService) {
        this.casTicketService = (TicketService)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.response = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
            this.ticket = this.getCASTicket(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ProxyGrantingTicket pgt;
        if (this.ticket == null || !(this.ticket instanceof ProxyTicket)) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.InvalidTicketType.event((Object)this));
            return;
        }
        String pgtId = ((ProxyTicket)this.ticket).getPgtId();
        do {
            if ((pgt = this.casTicketService.fetchProxyGrantingTicket(pgtId)) == null || Instant.now().isAfter(pgt.getExpirationInstant())) {
                this.log.debug("{} PGT {} {}", new Object[]{this.getLogPrefix(), pgtId, pgt == null ? "not found" : "expired"});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.BrokenProxyChain.event((Object)this));
                return;
            }
            this.response.addProxy(pgt.getProxyCallbackUrl());
        } while ((pgtId = pgt.getParentId()) != null);
    }
}

