/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport;

import org.ldaptive.AbstractConfig;

public final class ThreadPoolConfig
extends AbstractConfig {
    private String threadPoolName;
    private int ioThreads;
    private int messageThreads = -1;
    private ShutdownStrategy shutdownStrategy = ShutdownStrategy.CONNECTION_CLOSE;

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String name) {
        this.assertMutable();
        this.logger.trace("setting threadPoolName: {}", (Object)name);
        this.threadPoolName = name;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int count) {
        this.assertMutable();
        if (count < 0) {
            throw new IllegalArgumentException("ioThreads must be greater than or equal to 0");
        }
        this.logger.trace("setting ioThreads: {}", (Object)count);
        this.ioThreads = count;
    }

    public int getMessageThreads() {
        return this.messageThreads;
    }

    public void setMessageThreads(int count) {
        this.assertMutable();
        if (count < -1) {
            throw new IllegalArgumentException("messageThreads must be greater than or equal to -1");
        }
        this.logger.trace("setting messageThreads: {}", (Object)count);
        this.messageThreads = count;
    }

    public ShutdownStrategy getShutdownStrategy() {
        return this.shutdownStrategy;
    }

    public void setShutdownStrategy(ShutdownStrategy strategy) {
        this.assertMutable();
        this.logger.trace("setting shutdownStrategy: {}", (Object)strategy);
        this.shutdownStrategy = strategy;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::threadPoolName=" + this.threadPoolName + ", ioThreads=" + this.ioThreads + ", messageThreads=" + this.messageThreads + ", shutdownStrategy=" + String.valueOf((Object)this.shutdownStrategy) + "]";
    }

    public static ThreadPoolConfig singleIoThread(String name, ShutdownStrategy strategy) {
        return ThreadPoolConfig.builder().threadPoolName(name).ioThreads(1).shutdownStrategy(strategy).freeze().build();
    }

    public static ThreadPoolConfig defaultIoThreads(String name, ShutdownStrategy strategy) {
        return ThreadPoolConfig.builder().threadPoolName(name).ioThreads(0).shutdownStrategy(strategy).freeze().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ShutdownStrategy {
        CONNECTION_CLOSE,
        CONNECTION_FACTORY_CLOSE,
        NEVER;

    }

    public static final class Builder {
        private final ThreadPoolConfig object = new ThreadPoolConfig();

        private Builder() {
        }

        public Builder freeze() {
            this.object.freeze();
            return this;
        }

        public Builder threadPoolName(String name) {
            this.object.setThreadPoolName(name);
            return this;
        }

        public Builder ioThreads(int count) {
            this.object.setIoThreads(count);
            return this;
        }

        public Builder messageThreads(int count) {
            this.object.setMessageThreads(count);
            return this;
        }

        public Builder shutdownStrategy(ShutdownStrategy strategy) {
            this.object.setShutdownStrategy(strategy);
            return this;
        }

        public ThreadPoolConfig build() {
            return this.object;
        }
    }
}

