/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.io.LdifReader;
import org.ldaptive.schema.Schema;
import org.ldaptive.schema.SchemaUtils;
import org.ldaptive.schema.transcode.AttributeTypeValueTranscoder;
import org.ldaptive.schema.transcode.DITContentRuleValueTranscoder;
import org.ldaptive.schema.transcode.DITStructureRuleValueTranscoder;
import org.ldaptive.schema.transcode.MatchingRuleUseValueTranscoder;
import org.ldaptive.schema.transcode.MatchingRuleValueTranscoder;
import org.ldaptive.schema.transcode.NameFormValueTranscoder;
import org.ldaptive.schema.transcode.ObjectClassValueTranscoder;
import org.ldaptive.schema.transcode.SyntaxValueTranscoder;

public final class SchemaFactory {
    private static final String SUBSCHEMA_SUBENTRY_ATTR_NAME = "subschemaSubentry";
    private static final String ATTRIBUTE_TYPES_ATTR_NAME = "attributeTypes";
    private static final String DIT_CONTENT_RULES_ATTR_NAME = "dITContentRules";
    private static final String DIT_STRUCTURE_RULES_ATTR_NAME = "dITStructureRules";
    private static final String LDAP_SYNTAXES_ATTR_NAME = "ldapSyntaxes";
    private static final String MATCHING_RULES_ATTR_NAME = "matchingRules";
    private static final String MATCHING_RULE_USE_ATTR_NAME = "matchingRuleUse";
    private static final String NAME_FORMS_ATTR_NAME = "nameForms";
    private static final String OBJECT_CLASS_ATTR_NAME = "objectClasses";

    private SchemaFactory() {
    }

    public static Schema createSchema(InputStream is) throws IOException {
        LdifReader reader = new LdifReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        return SchemaFactory.createSchema(reader.read().getEntry());
    }

    public static Schema createSchema(ConnectionFactory factory) throws LdapException {
        LdapEntry rootDSE = SchemaUtils.getLdapEntry(factory, "", "(objectClass=*)", SUBSCHEMA_SUBENTRY_ATTR_NAME);
        String entryDn = rootDSE.getAttribute(SUBSCHEMA_SUBENTRY_ATTR_NAME).getStringValue();
        return SchemaFactory.createSchema(SchemaUtils.getLdapEntry(factory, entryDn, "(objectClass=subSchema)", ReturnAttributes.ALL.value()));
    }

    public static Schema createSchema(ConnectionFactory factory, String entryDn) throws LdapException {
        return SchemaFactory.createSchema(SchemaUtils.getLdapEntry(factory, entryDn, "(objectClass=subSchema)", ReturnAttributes.ALL.value()));
    }

    public static Schema createSchema(LdapEntry schemaEntry) {
        LdapUtils.assertNotNullArg(schemaEntry, "Schema entry cannot be null");
        Schema schema = new Schema();
        schemaEntry.processAttribute(ATTRIBUTE_TYPES_ATTR_NAME, attr -> schema.setAttributeTypes(attr.getValues(new AttributeTypeValueTranscoder().decoder())));
        schemaEntry.processAttribute(DIT_CONTENT_RULES_ATTR_NAME, attr -> schema.setDITContentRules(attr.getValues(new DITContentRuleValueTranscoder().decoder())));
        schemaEntry.processAttribute(DIT_STRUCTURE_RULES_ATTR_NAME, attr -> schema.setDITStructureRules(attr.getValues(new DITStructureRuleValueTranscoder().decoder())));
        schemaEntry.processAttribute(LDAP_SYNTAXES_ATTR_NAME, attr -> schema.setSyntaxes(attr.getValues(new SyntaxValueTranscoder().decoder())));
        schemaEntry.processAttribute(MATCHING_RULES_ATTR_NAME, attr -> schema.setMatchingRules(attr.getValues(new MatchingRuleValueTranscoder().decoder())));
        schemaEntry.processAttribute(MATCHING_RULE_USE_ATTR_NAME, attr -> schema.setMatchingRuleUses(attr.getValues(new MatchingRuleUseValueTranscoder().decoder())));
        schemaEntry.processAttribute(NAME_FORMS_ATTR_NAME, attr -> schema.setNameForms(attr.getValues(new NameFormValueTranscoder().decoder())));
        schemaEntry.processAttribute(OBJECT_CLASS_ATTR_NAME, attr -> schema.setObjectClasses(attr.getValues(new ObjectClassValueTranscoder().decoder())));
        return schema;
    }
}

