/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Predicate;
import org.ldaptive.LdapUtils;
import org.ldaptive.pool.AbstractPruneStrategy;
import org.ldaptive.pool.PooledConnectionProxy;

public class AgePruneStrategy
extends AbstractPruneStrategy {
    private static final Duration DEFAULT_AGE_TIME = Duration.ofHours(1L);
    private Duration ageTime;
    private int prunePriority = -1;
    private int prunePriorityFactor;

    public AgePruneStrategy() {
        this(DEFAULT_AGE_TIME);
    }

    public AgePruneStrategy(Duration age) {
        this(age.dividedBy(2L), age);
    }

    public AgePruneStrategy(Duration period, Duration age) {
        this.setPrunePeriod(period);
        this.setAgeTime(age);
    }

    @Override
    public List<Predicate<PooledConnectionProxy>> getPruneConditions() {
        if (Duration.ZERO.equals(this.ageTime)) {
            return List.of(proxy -> false);
        }
        if (this.prunePriority >= 0) {
            return List.of(proxy -> {
                long priority = proxy.getConnection().getLdapURL().getPriority();
                if (priority >= (long)this.prunePriority) {
                    Instant timeCreated = proxy.getCreatedTime();
                    this.logger.trace("evaluating created time {} for connection {}", (Object)timeCreated, proxy);
                    if (this.prunePriorityFactor > 0) {
                        long factor = (long)this.prunePriorityFactor * (priority + 1L);
                        return timeCreated == null || timeCreated.plus(this.ageTime.dividedBy(factor)).isBefore(Instant.now());
                    }
                    return timeCreated == null || timeCreated.plus(this.ageTime).isBefore(Instant.now());
                }
                return false;
            });
        }
        return List.of(proxy -> {
            Instant timeCreated = proxy.getCreatedTime();
            return timeCreated == null || timeCreated.plus(this.ageTime).isBefore(Instant.now());
        });
    }

    @Override
    public int getStatisticsSize() {
        return 0;
    }

    public Duration getAgeTime() {
        return this.ageTime;
    }

    public void setAgeTime(Duration time) {
        this.assertMutable();
        LdapUtils.assertNotNullArgOr(time, Duration::isNegative, "Age time cannot be null or negative");
        this.ageTime = time;
    }

    public int getPrunePriority() {
        return this.prunePriority;
    }

    public void setPrunePriority(int i) {
        this.assertMutable();
        if (i < -1) {
            throw new IllegalArgumentException("Prune priority must be greater than or equal to -1");
        }
        this.prunePriority = i;
    }

    public int getPrunePriorityFactor() {
        return this.prunePriorityFactor;
    }

    public void setPrunePriorityFactor(int i) {
        this.assertMutable();
        if (i < 0) {
            throw new IllegalArgumentException("Prune priority factor must be greater than or equal to zero");
        }
        this.prunePriorityFactor = i;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::prunePeriod=" + String.valueOf(this.getPrunePeriod()) + ", ageTime=" + String.valueOf(this.ageTime) + ", prunePriority=" + this.prunePriority + ", prunePriorityFactor=" + this.prunePriorityFactor + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractPruneStrategy.AbstractBuilder<Builder, AgePruneStrategy> {
        protected Builder() {
            super(new AgePruneStrategy());
        }

        protected Builder(AgePruneStrategy strategy) {
            super(strategy);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder age(Duration time) {
            ((AgePruneStrategy)this.object).setAgeTime(time);
            return this.self();
        }

        public Builder priority(int i) {
            ((AgePruneStrategy)this.object).setPrunePriority(i);
            return this.self();
        }

        public Builder priorityFactor(int i) {
            ((AgePruneStrategy)this.object).setPrunePriorityFactor(i);
            return this.self();
        }
    }
}

