/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.LdapUtils;
import org.ldaptive.pool.PooledConnectionProxy;
import org.ldaptive.pool.PruneStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPruneStrategy
extends AbstractFreezable
implements PruneStrategy {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Duration prunePeriod;

    @Override
    public Duration getPrunePeriod() {
        return this.prunePeriod;
    }

    public void setPrunePeriod(Duration period) {
        this.assertMutable();
        LdapUtils.assertNotNullArgOr(period, p -> p.isNegative() || p.isZero(), "Prune period cannot be null, negative or zero");
        this.prunePeriod = period;
    }

    @Override
    public void accept(Supplier<Iterator<PooledConnectionProxy>> connections) {
        List<Predicate<PooledConnectionProxy>> predicates = this.getPruneConditions();
        this.logger.trace("prune strategy {} has {} conditions", (Object)this, (Object)predicates.size());
        for (Predicate<PooledConnectionProxy> predicate : predicates) {
            Iterator<PooledConnectionProxy> iterator = connections.get();
            while (iterator.hasNext()) {
                PooledConnectionProxy pc = iterator.next();
                if (predicate.test(pc)) {
                    this.logger.trace("prune approved on {} with {}", (Object)pc, (Object)this);
                    iterator.remove();
                    pc.getConnection().close();
                    this.logger.trace("prune removed {} from {}", (Object)pc, (Object)this);
                    continue;
                }
                this.logger.trace("prune denied on {} with {}", (Object)pc, (Object)this);
            }
        }
    }

    protected abstract List<Predicate<PooledConnectionProxy>> getPruneConditions();

    protected static abstract class AbstractBuilder<B, T extends AbstractPruneStrategy> {
        protected final T object;

        protected AbstractBuilder(T t) {
            this.object = t;
        }

        protected abstract B self();

        public B freeze() {
            ((AbstractFreezable)this.object).freeze();
            return this.self();
        }

        public B period(Duration period) {
            ((AbstractPruneStrategy)this.object).setPrunePeriod(period);
            return this.self();
        }

        public T build() {
            return this.object;
        }
    }
}

