/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.ConstructedDEREncoder;
import org.ldaptive.asn1.ContextDERTag;
import org.ldaptive.asn1.DEREncoder;
import org.ldaptive.asn1.NullType;
import org.ldaptive.filter.Filter;
import org.ldaptive.filter.FilterSet;

public class AndFilter
implements FilterSet {
    private static final int HASH_CODE_SEED = 10009;
    private final List<Filter> filterComponents = new ArrayList<Filter>();

    public AndFilter() {
    }

    public AndFilter(Filter ... components) {
        this.filterComponents.addAll(Arrays.asList(LdapUtils.assertNotContainsNullArgOr(components, Objects::isNull, "Filter components cannot be null or contain null")));
    }

    @Override
    public Filter.Type getType() {
        return Filter.Type.AND;
    }

    @Override
    public void add(Filter component) {
        this.filterComponents.add(LdapUtils.assertNotNullArg(component, "Filter component cannot be null"));
    }

    public List<Filter> getComponents() {
        return Collections.unmodifiableList(this.filterComponents);
    }

    @Override
    public DEREncoder getEncoder() {
        LdapUtils.assertNotContainsNullState(this.filterComponents, "Filter components cannot contain null");
        if (this.filterComponents.isEmpty()) {
            return new NullType(new ContextDERTag(Filter.Type.AND.ordinal(), true));
        }
        return new ConstructedDEREncoder(new ContextDERTag(Filter.Type.AND.ordinal(), true), (DEREncoder[])this.filterComponents.stream().map(Filter::getEncoder).toArray(DEREncoder[]::new));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AndFilter) {
            AndFilter v = (AndFilter)o;
            return LdapUtils.areEqual(this.filterComponents, v.filterComponents);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(10009, this.filterComponents);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::filterComponents=" + String.valueOf(this.filterComponents);
    }
}

