/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.ldaptive.AbstractConnectionValidator;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionValidator;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.Result;
import org.ldaptive.SearchConnectionValidator;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResultReference;
import org.ldaptive.SingleConnectionFactory;
import org.ldaptive.control.util.CookieManager;
import org.ldaptive.control.util.SyncReplClient;
import org.ldaptive.extended.SyncInfoMessage;
import org.ldaptive.transport.ThreadPoolConfig;
import org.ldaptive.transport.Transport;
import org.ldaptive.transport.TransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncReplRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncReplRunner.class);
    private static final int IO_WORKER_THREADS = 1;
    private static final int MESSAGE_WORKER_THREADS = 4;
    private final SearchRequest searchRequest;
    private final CookieManager cookieManager;
    private final SyncReplClient syncReplClient;
    private Supplier<Boolean> onStart;
    private Consumer<LdapEntry> onEntry;
    private Consumer<SearchResultReference> onReference;
    private Consumer<Result> onResult;
    private Consumer<SyncInfoMessage> onMessage;
    private Consumer<Exception> onException;
    private boolean started;

    public SyncReplRunner(SingleConnectionFactory cf, SearchRequest request, CookieManager manager) {
        this.syncReplClient = new SyncReplClient(cf, true);
        this.searchRequest = LdapUtils.assertNotNullArg(request, "Search request cannot be null");
        this.cookieManager = LdapUtils.assertNotNullArg(manager, "Cookie manager cannot be null");
        cf.setOnOpen(conn -> {
            try {
                this.syncReplClient.send(this.searchRequest, this.cookieManager);
            }
            catch (LdapException e) {
                LOGGER.error("Could not send sync repl request", (Throwable)e);
                return false;
            }
            return true;
        });
        cf.setOnClose(conn -> {
            try {
                if (!this.syncReplClient.isComplete()) {
                    this.syncReplClient.cancel();
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not cancel sync repl request", (Throwable)e);
                return false;
            }
            return true;
        });
    }

    public static SingleConnectionFactory createConnectionFactory(ConnectionConfig config) {
        return SyncReplRunner.createConnectionFactory(config, ((SearchConnectionValidator.Builder)((SearchConnectionValidator.Builder)((SearchConnectionValidator.Builder)SearchConnectionValidator.builder().period(Duration.ofMinutes(1L))).timeout(Duration.ofSeconds(5L))).timeoutIsFailure(false)).build());
    }

    public static SingleConnectionFactory createConnectionFactory(ConnectionConfig config, ConnectionValidator validator) {
        return SyncReplRunner.createConnectionFactory(SyncReplRunner.createTransport(), config, validator);
    }

    public static SingleConnectionFactory createConnectionFactory(Transport transport, ConnectionConfig config, ConnectionValidator validator) {
        SingleConnectionFactory factory = new SingleConnectionFactory(config, transport);
        factory.setValidator(validator);
        SyncReplRunner.configureConnectionFactory(factory);
        return factory;
    }

    public static void configureConnectionFactory(SingleConnectionFactory factory) {
        AbstractConnectionValidator validator;
        ConnectionConfig newConfig = ConnectionConfig.copy(factory.getConnectionConfig());
        newConfig.setAutoReconnect(false);
        newConfig.setAutoReplay(false);
        newConfig.setAutoRead(false);
        factory.setConnectionConfig(newConfig);
        factory.setFailFastInitialize(false);
        factory.setNonBlockingInitialize(false);
        if (factory.getValidator() instanceof AbstractConnectionValidator && (validator = (AbstractConnectionValidator)factory.getValidator()).getOnFailure() == null) {
            validator.setOnFailure(factory.new SingleConnectionFactory.ReinitializeConnectionConsumer());
        }
    }

    private static Transport createTransport() {
        return TransportFactory.getTransport(ThreadPoolConfig.builder().threadPoolName("ldaptive-sync-repl-runner").ioThreads(1).messageThreads(4).shutdownStrategy(ThreadPoolConfig.ShutdownStrategy.NEVER).freeze().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnStart(Supplier<Boolean> supplier) {
        SyncReplClient syncReplClient = this.syncReplClient;
        synchronized (syncReplClient) {
            if (this.started) {
                throw new IllegalStateException("Cannot set onStart, runner already started");
            }
            this.onStart = supplier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnEntry(Consumer<LdapEntry> consumer) {
        SyncReplClient syncReplClient = this.syncReplClient;
        synchronized (syncReplClient) {
            if (this.started) {
                throw new IllegalStateException("Cannot set onEntry, runner already started");
            }
            this.onEntry = consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnReference(Consumer<SearchResultReference> consumer) {
        SyncReplClient syncReplClient = this.syncReplClient;
        synchronized (syncReplClient) {
            if (this.started) {
                throw new IllegalStateException("Cannot set onReference, runner already started");
            }
            this.onReference = consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnResult(Consumer<Result> consumer) {
        SyncReplClient syncReplClient = this.syncReplClient;
        synchronized (syncReplClient) {
            if (this.started) {
                throw new IllegalStateException("Cannot set onResult, runner already started");
            }
            this.onResult = consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnMessage(Consumer<SyncInfoMessage> consumer) {
        SyncReplClient syncReplClient = this.syncReplClient;
        synchronized (syncReplClient) {
            if (this.started) {
                throw new IllegalStateException("Cannot set onMessage, runner already started");
            }
            this.onMessage = consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnException(Consumer<Exception> consumer) {
        SyncReplClient syncReplClient = this.syncReplClient;
        synchronized (syncReplClient) {
            if (this.started) {
                throw new IllegalStateException("Cannot set onException, runner already started");
            }
            this.onException = consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        SyncReplClient syncReplClient = this.syncReplClient;
        synchronized (syncReplClient) {
            if (this.started) {
                throw new IllegalStateException("Runner has already been started");
            }
            this.syncReplClient.setOnEntry(this.onEntry);
            this.syncReplClient.setOnReference(this.onReference);
            this.syncReplClient.setOnResult(this.onResult);
            this.syncReplClient.setOnMessage(this.onMessage);
            this.syncReplClient.setOnException(this.onException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SyncReplClient syncReplClient = this.syncReplClient;
        synchronized (syncReplClient) {
            if (this.started) {
                throw new IllegalStateException("Runner has already been started");
            }
            try {
                if (this.onStart != null && !this.onStart.get().booleanValue()) {
                    throw new RuntimeException("Start aborted from " + String.valueOf(this.onStart));
                }
                LOGGER.debug("Starting runner {}", (Object)this);
                if (!((SingleConnectionFactory)this.syncReplClient.getConnectionFactory()).isInitialized()) {
                    ((SingleConnectionFactory)this.syncReplClient.getConnectionFactory()).initialize();
                }
                this.started = true;
                LOGGER.info("Runner {} started", (Object)this);
            }
            catch (Exception e) {
                LOGGER.error("Could not start the runner", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SyncReplClient syncReplClient = this.syncReplClient;
        synchronized (syncReplClient) {
            if (!this.started) {
                throw new IllegalStateException("Runner has not been started");
            }
            LOGGER.debug("Stopping runner {}", (Object)this);
            this.syncReplClient.close();
            this.started = false;
            LOGGER.info("Runner {} stopped", (Object)this);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartSearch() {
        SyncReplClient syncReplClient = this.syncReplClient;
        synchronized (syncReplClient) {
            if (!this.started) {
                throw new IllegalStateException("Cannot restart the search, runner is stopped");
            }
            try {
                if (!this.syncReplClient.isComplete()) {
                    this.syncReplClient.cancel();
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not cancel sync repl request", (Throwable)e);
            }
            try {
                this.syncReplClient.send(this.searchRequest, this.cookieManager);
            }
            catch (LdapException e) {
                throw new IllegalStateException("Could not send sync repl request", e);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::syncReplClient=" + String.valueOf(this.syncReplClient) + ", searchRequest=" + String.valueOf(this.searchRequest) + ", cookieManager=" + String.valueOf(this.cookieManager) + ", onStart=" + String.valueOf(this.onStart) + ", onEntry=" + String.valueOf(this.onEntry) + ", onReference=" + String.valueOf(this.onReference) + ", onResult=" + String.valueOf(this.onResult) + ", onMessage=" + String.valueOf(this.onMessage) + ", onException=" + String.valueOf(this.onException) + ", started=" + this.started;
    }
}

