/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control;

import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.BooleanType;
import org.ldaptive.asn1.DERBuffer;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERPath;
import org.ldaptive.control.AbstractResponseControl;

public class SyncDoneControl
extends AbstractResponseControl {
    public static final String OID = "1.3.6.1.4.1.4203.1.9.1.3";
    private static final int HASH_CODE_SEED = 757;
    private byte[] cookie;
    private boolean refreshDeletes;

    public SyncDoneControl() {
        super(OID);
    }

    public SyncDoneControl(boolean critical) {
        super(OID, critical);
    }

    public SyncDoneControl(byte[] value) {
        super(OID);
        this.cookie = value;
        this.freeze();
    }

    public SyncDoneControl(byte[] value, boolean critical) {
        super(OID, critical);
        this.cookie = value;
        this.freeze();
    }

    public SyncDoneControl(byte[] value, boolean refresh, boolean critical) {
        super(OID, critical);
        this.cookie = value;
        this.refreshDeletes = refresh;
        this.freeze();
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public boolean getRefreshDeletes() {
        return this.refreshDeletes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SyncDoneControl && super.equals(o)) {
            SyncDoneControl v = (SyncDoneControl)o;
            return LdapUtils.areEqual(this.cookie, v.cookie) && LdapUtils.areEqual(this.refreshDeletes, v.refreshDeletes);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(757, this.getOID(), this.getCriticality(), this.cookie, this.refreshDeletes);
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::criticality=" + this.getCriticality() + ", cookie=" + LdapUtils.base64Encode(this.cookie) + ", refreshDeletes=" + this.refreshDeletes + "]";
    }

    @Override
    public void decode(DERBuffer encoded) {
        this.freezeAndAssertMutable();
        DERParser parser = new DERParser();
        parser.registerHandler(CookieHandler.PATH, new CookieHandler(this));
        parser.registerHandler(RefreshDeletesHandler.PATH, new RefreshDeletesHandler(this));
        try {
            parser.parse(encoded);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing response", e);
        }
    }

    private static class CookieHandler
    extends AbstractParseHandler<SyncDoneControl> {
        public static final DERPath PATH = new DERPath("/SEQ/OCTSTR[0]");

        CookieHandler(SyncDoneControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            byte[] cookie = encoded.getRemainingBytes();
            if (cookie != null && cookie.length > 0) {
                ((SyncDoneControl)this.getObject()).cookie = cookie;
            }
        }
    }

    private static class RefreshDeletesHandler
    extends AbstractParseHandler<SyncDoneControl> {
        public static final DERPath PATH = new DERPath("/SEQ/BOOL");

        RefreshDeletesHandler(SyncDoneControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            ((SyncDoneControl)this.getObject()).refreshDeletes = BooleanType.decode(encoded);
        }
    }
}

