/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control;

import javax.security.auth.login.AccountException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.DERBuffer;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERPath;
import org.ldaptive.asn1.IntegerType;
import org.ldaptive.auth.AccountState;
import org.ldaptive.control.AbstractResponseControl;
import org.ldaptive.control.RequestControl;

public class PasswordPolicyControl
extends AbstractResponseControl
implements RequestControl {
    public static final String OID = "1.3.6.1.4.1.42.2.27.8.5.1";
    private static final int HASH_CODE_SEED = 719;
    private Warning warning;
    private Error error;

    public PasswordPolicyControl() {
        super(OID);
    }

    public PasswordPolicyControl(boolean critical) {
        super(OID, critical);
    }

    public PasswordPolicyControl(WarningType type, int value) {
        super(OID);
        this.warning = new Warning(type, value);
        this.freeze();
    }

    public PasswordPolicyControl(Error err) {
        super(OID);
        this.error = err;
        this.freeze();
    }

    public PasswordPolicyControl(WarningType type, int value, Error err) {
        super(OID);
        this.warning = new Warning(type, value);
        this.error = err;
        this.freeze();
    }

    public PasswordPolicyControl(WarningType type, int value, boolean critical) {
        super(OID, critical);
        this.warning = new Warning(type, value);
        this.freeze();
    }

    public PasswordPolicyControl(Error err, boolean critical) {
        super(OID, critical);
        this.error = err;
        this.freeze();
    }

    public PasswordPolicyControl(WarningType type, int value, Error err, boolean critical) {
        super(OID, critical);
        this.warning = new Warning(type, value);
        this.error = err;
        this.freeze();
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public boolean hasWarning(WarningType type) {
        return this.warning != null && this.warning.getWarningType() == type;
    }

    public Error getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PasswordPolicyControl && super.equals(o)) {
            PasswordPolicyControl v = (PasswordPolicyControl)o;
            return LdapUtils.areEqual(this.warning, v.warning) && LdapUtils.areEqual(this.error, v.error);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(719, this.getOID(), this.getCriticality(), this.warning, this.error);
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::criticality=" + this.getCriticality() + ", warning=" + String.valueOf(this.warning) + ", error=" + String.valueOf(this.error) + "]";
    }

    @Override
    public byte[] encode() {
        return null;
    }

    @Override
    public void decode(DERBuffer encoded) {
        this.freezeAndAssertMutable();
        DERParser parser = new DERParser();
        parser.registerHandler(TimeBeforeExpirationHandler.PATH, new TimeBeforeExpirationHandler(this));
        parser.registerHandler(GraceAuthnsRemainingHandler.PATH, new GraceAuthnsRemainingHandler(this));
        parser.registerHandler(ErrorHandler.PATH, new ErrorHandler(this));
        try {
            parser.parse(encoded);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing response", e);
        }
    }

    public static final class Warning {
        private final WarningType warningType;
        private final int value;

        private Warning(WarningType type, int i) {
            this.warningType = LdapUtils.assertNotNullArg(type, "Warning type cannot be null");
            this.value = i;
        }

        public WarningType getWarningType() {
            return this.warningType;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Warning) {
                Warning v = (Warning)o;
                return LdapUtils.areEqual((Object)this.warningType, (Object)v.warningType) && LdapUtils.areEqual(this.value, v.value);
            }
            return false;
        }

        public int hashCode() {
            return LdapUtils.computeHashCode(719, new Object[]{this.warningType, this.value});
        }

        public String toString() {
            return "[" + this.getClass().getName() + "@" + this.hashCode() + "::warningType=" + String.valueOf((Object)this.warningType) + ", value=" + this.value + "]";
        }
    }

    public static enum WarningType {
        TIME_BEFORE_EXPIRATION,
        GRACE_AUTHNS_REMAINING;

    }

    public static enum Error implements AccountState.Error
    {
        PASSWORD_EXPIRED(0),
        ACCOUNT_LOCKED(1),
        CHANGE_AFTER_RESET(2),
        PASSWORD_MOD_NOT_ALLOWED(3),
        MUST_SUPPLY_OLD_PASSWORD(4),
        INSUFFICIENT_PASSWORD_QUALITY(5),
        PASSWORD_TOO_SHORT(6),
        PASSWORD_TOO_YOUNG(7),
        PASSWORD_IN_HISTORY(8),
        PASSWORD_TOO_LONG(9);

        private final int code;

        private Error(int i) {
            this.code = i;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.name();
        }

        @Override
        public void throwSecurityException() throws LoginException {
            switch (this) {
                case PASSWORD_EXPIRED: 
                case CHANGE_AFTER_RESET: {
                    throw new CredentialExpiredException(this.name());
                }
                case ACCOUNT_LOCKED: {
                    throw new AccountLockedException(this.name());
                }
                case PASSWORD_MOD_NOT_ALLOWED: 
                case MUST_SUPPLY_OLD_PASSWORD: {
                    throw new AccountException(this.name());
                }
                case INSUFFICIENT_PASSWORD_QUALITY: 
                case PASSWORD_TOO_SHORT: 
                case PASSWORD_TOO_YOUNG: 
                case PASSWORD_IN_HISTORY: 
                case PASSWORD_TOO_LONG: {
                    throw new CredentialException(this.name());
                }
            }
            throw new IllegalStateException("Unknown password policy error: " + String.valueOf(this));
        }

        public static Error valueOf(int code) {
            for (Error e : Error.values()) {
                if (e.getCode() != code) continue;
                return e;
            }
            return null;
        }
    }

    private static class TimeBeforeExpirationHandler
    extends AbstractParseHandler<PasswordPolicyControl> {
        public static final DERPath PATH = new DERPath("/SEQ/CTX(0)/CTX(0)");

        TimeBeforeExpirationHandler(PasswordPolicyControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            ((PasswordPolicyControl)this.getObject()).warning = new Warning(WarningType.TIME_BEFORE_EXPIRATION, IntegerType.decode(encoded).intValue());
        }
    }

    private static class GraceAuthnsRemainingHandler
    extends AbstractParseHandler<PasswordPolicyControl> {
        public static final DERPath PATH = new DERPath("/SEQ/CTX(0)/CTX(1)");

        GraceAuthnsRemainingHandler(PasswordPolicyControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            ((PasswordPolicyControl)this.getObject()).warning = new Warning(WarningType.GRACE_AUTHNS_REMAINING, IntegerType.decode(encoded).intValue());
        }
    }

    private static class ErrorHandler
    extends AbstractParseHandler<PasswordPolicyControl> {
        public static final DERPath PATH = new DERPath("/SEQ/CTX(1)");

        ErrorHandler(PasswordPolicyControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            int errValue = IntegerType.decode(encoded).intValue();
            Error e = Error.valueOf(errValue);
            if (e == null) {
                throw new IllegalArgumentException("Unknown error code " + errValue);
            }
            ((PasswordPolicyControl)this.getObject()).error = e;
        }
    }
}

