/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth.ext;

import java.time.Clock;
import java.time.ZonedDateTime;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordPolicyAccountState;
import org.ldaptive.control.PasswordPolicyControl;

public class PasswordPolicyAuthenticationResponseHandler
implements AuthenticationResponseHandler {
    private final Clock expirationClock;

    public PasswordPolicyAuthenticationResponseHandler() {
        this(Clock.systemDefaultZone());
    }

    PasswordPolicyAuthenticationResponseHandler(Clock clock) {
        this.expirationClock = clock;
    }

    @Override
    public void handle(AuthenticationResponse response) {
        PasswordPolicyControl ppc = (PasswordPolicyControl)response.getControl("1.3.6.1.4.1.42.2.27.8.5.1");
        if (ppc != null) {
            ZonedDateTime exp = this.getTimeBeforeExpiration(ppc);
            if (exp != null) {
                if (ppc.hasError()) {
                    response.setAccountState(new PasswordPolicyAccountState(exp, ppc.getError()));
                } else {
                    response.setAccountState(new PasswordPolicyAccountState(exp));
                }
            } else if (ppc.hasWarning(PasswordPolicyControl.WarningType.GRACE_AUTHNS_REMAINING)) {
                int graceAuthnsRemaining = ppc.getWarning().getValue();
                if (ppc.hasError()) {
                    response.setAccountState(new PasswordPolicyAccountState(graceAuthnsRemaining, ppc.getError()));
                } else {
                    response.setAccountState(new PasswordPolicyAccountState(graceAuthnsRemaining));
                }
            } else if (ppc.hasError()) {
                response.setAccountState(new PasswordPolicyAccountState(ppc.getError()));
            }
        }
    }

    private ZonedDateTime getTimeBeforeExpiration(PasswordPolicyControl ppc) {
        if (ppc.hasWarning(PasswordPolicyControl.WarningType.TIME_BEFORE_EXPIRATION)) {
            return ZonedDateTime.now(this.expirationClock).plusSeconds(ppc.getWarning().getValue());
        }
        return null;
    }
}

