/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ldaptive.LdapURL;
import org.ldaptive.LdapUtils;

public final class LdapURLActivatorService {
    private static final String ACTIVATOR_PERIOD_PROPERTY = "org.ldaptive.urlActivatorPeriod";
    private static final String STALE_PERIOD_PROPERTY = "org.ldaptive.urlActivatorStalePeriod";
    private static final Duration ACTIVATOR_PERIOD = Duration.ofMinutes(LdapUtils.parseLong(System.getProperty("org.ldaptive.urlActivatorPeriod", "5"), l -> l > 0L, 5L));
    private static final Duration STALE_PERIOD = Duration.ofHours(LdapUtils.parseLong(System.getProperty("org.ldaptive.urlActivatorStalePeriod", "4"), l -> l > 0L, 4L));
    private static final LdapURLActivatorService INSTANCE = new LdapURLActivatorService();
    private final Queue<LdapURL> inactiveUrls = new ConcurrentLinkedQueue<LdapURL>();

    private LdapURLActivatorService() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r, "ldaptive-ldap-url-activator");
            t.setDaemon(true);
            return t;
        });
        executor.scheduleAtFixedRate(this::testInactiveUrls, ACTIVATOR_PERIOD.toMillis(), ACTIVATOR_PERIOD.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static LdapURLActivatorService getInstance() {
        return INSTANCE;
    }

    public static Duration getPeriod() {
        return ACTIVATOR_PERIOD;
    }

    public void registerUrl(LdapURL url) {
        this.inactiveUrls.add(LdapUtils.assertNotNullArg(url, "URL cannot be null"));
    }

    public Collection<LdapURL> getInactiveUrls() {
        return Collections.unmodifiableCollection(this.inactiveUrls);
    }

    void testInactiveUrls() {
        for (LdapURL url : this.inactiveUrls) {
            if (url.isActive() || !url.getRetryMetadata().getConnectionStrategy().getRetryCondition().test(url)) continue;
            if (url.getRetryMetadata().getConnectionStrategy().getActivateCondition().test(url)) {
                url.getRetryMetadata().getConnectionStrategy().success(url);
                continue;
            }
            url.getRetryMetadata().recordFailure(Instant.now());
            this.activateIfStale(url);
        }
        this.inactiveUrls.removeIf(LdapURL::isActive);
    }

    private void activateIfStale(LdapURL url) {
        Instant now = Instant.now();
        if (url.getRetryMetadata().getSuccessTime() == null) {
            if (url.getRetryMetadata().getCreateTime().plus(STALE_PERIOD).isBefore(now)) {
                url.activate();
            }
        } else if (url.getRetryMetadata().getSuccessTime().plus(STALE_PERIOD).isBefore(now)) {
            url.activate();
        }
    }

    void clear() {
        this.inactiveUrls.clear();
    }
}

