/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.AnonymousBindRequest;
import org.ldaptive.BindRequest;
import org.ldaptive.BindResponse;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.Credential;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.Result;
import org.ldaptive.SimpleBindRequest;
import org.ldaptive.control.RequestControl;
import org.ldaptive.sasl.CramMD5BindRequest;
import org.ldaptive.sasl.DigestMD5BindRequest;
import org.ldaptive.sasl.GssApiBindRequest;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.SaslBindRequest;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.sasl.ScramBindRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindConnectionInitializer
extends AbstractFreezable
implements ConnectionInitializer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String bindDn;
    private Credential bindCredential;
    private SaslConfig bindSaslConfig;
    private RequestControl[] bindControls;

    public BindConnectionInitializer() {
    }

    public BindConnectionInitializer(String dn, String credential) {
        this.setBindDn(dn);
        this.setBindCredential(new Credential(credential));
    }

    public BindConnectionInitializer(String dn, Credential credential) {
        this.setBindDn(dn);
        this.setBindCredential(credential);
    }

    @Override
    public void freeze() {
        super.freeze();
        BindConnectionInitializer.freeze(this.bindSaslConfig);
    }

    public final String getBindDn() {
        return this.bindDn;
    }

    public final void setBindDn(String dn) {
        this.assertMutable();
        this.logger.trace("setting bindDn: {}", (Object)dn);
        this.bindDn = dn;
    }

    public final Credential getBindCredential() {
        return this.bindCredential != null ? Credential.copy(this.bindCredential) : null;
    }

    public final void setBindCredential(Credential credential) {
        this.assertMutable();
        this.logger.trace("setting bindCredential: <suppressed>");
        this.bindCredential = credential;
    }

    public final SaslConfig getBindSaslConfig() {
        return this.bindSaslConfig;
    }

    public final void setBindSaslConfig(SaslConfig config) {
        this.assertMutable();
        this.logger.trace("setting bindSaslConfig: {}", (Object)config);
        this.bindSaslConfig = config;
    }

    public final RequestControl[] getBindControls() {
        return LdapUtils.copyArray(this.bindControls);
    }

    public final void setBindControls(RequestControl ... cntrls) {
        this.assertMutable();
        this.logger.trace("setting bindControls: {}", (Object)Arrays.toString(cntrls));
        this.bindControls = LdapUtils.copyArray(cntrls);
    }

    @Override
    public Result initialize(Connection c) throws LdapException {
        BindResponse result;
        block10: {
            block9: {
                if (this.bindSaslConfig == null) break block9;
                switch (this.bindSaslConfig.getMechanism()) {
                    case EXTERNAL: {
                        result = c.operation((BindRequest)((Object)((SaslBindRequest.Builder)SaslBindRequest.builder().mechanism(Mechanism.EXTERNAL.mechanism()).credentials(this.bindSaslConfig.getAuthorizationId() != null ? this.bindSaslConfig.getAuthorizationId() : "").controls(this.bindControls)).build())).execute();
                        break block10;
                    }
                    case DIGEST_MD5: {
                        result = c.operation(new DigestMD5BindRequest(this.bindDn, this.bindSaslConfig.getAuthorizationId(), LdapUtils.assertNotNullArg(this.bindCredential, "DigestMD5 bind credential cannot be null").getString(), this.bindSaslConfig.getRealm(), DigestMD5BindRequest.createProperties(this.bindSaslConfig)));
                        break block10;
                    }
                    case CRAM_MD5: {
                        result = c.operation(new CramMD5BindRequest(this.bindDn, LdapUtils.assertNotNullArg(this.bindCredential, "CramMD5 bind credential cannot be null").getString()));
                        break block10;
                    }
                    case GSSAPI: {
                        result = c.operation(new GssApiBindRequest(this.bindDn, this.bindSaslConfig.getAuthorizationId(), this.bindCredential != null ? this.bindCredential.getString() : null, this.bindSaslConfig.getRealm(), GssApiBindRequest.createProperties(this.bindSaslConfig)));
                        break block10;
                    }
                    case SCRAM_SHA_1: {
                        result = c.operation(new ScramBindRequest(Mechanism.SCRAM_SHA_1, this.bindDn, this.bindCredential.getString()));
                        break block10;
                    }
                    case SCRAM_SHA_256: {
                        result = c.operation(new ScramBindRequest(Mechanism.SCRAM_SHA_256, this.bindDn, this.bindCredential.getString()));
                        break block10;
                    }
                    case SCRAM_SHA_512: {
                        result = c.operation(new ScramBindRequest(Mechanism.SCRAM_SHA_512, this.bindDn, this.bindCredential.getString()));
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException("Unknown SASL mechanism: " + String.valueOf((Object)this.bindSaslConfig.getMechanism()));
                    }
                }
            }
            result = this.bindDn == null && this.bindCredential == null ? c.operation((BindRequest)((Object)((AnonymousBindRequest.Builder)AnonymousBindRequest.builder().controls(this.bindControls)).build())).execute() : c.operation((BindRequest)((Object)((SimpleBindRequest.Builder)SimpleBindRequest.builder().dn(this.bindDn).password(this.bindCredential).controls(this.bindControls)).build())).execute();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.bindDn == null && this.bindCredential == null && this.bindSaslConfig == null && this.bindControls == null;
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::bindDn=" + this.bindDn + ", bindSaslConfig=" + String.valueOf(this.bindSaslConfig) + ", bindControls=" + Arrays.toString(this.bindControls);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final BindConnectionInitializer object = new BindConnectionInitializer();

        protected Builder() {
        }

        public Builder freeze() {
            this.object.freeze();
            return this;
        }

        public Builder dn(String dn) {
            this.object.setBindDn(dn);
            return this;
        }

        public Builder credential(Credential credential) {
            this.object.setBindCredential(credential);
            return this;
        }

        public Builder credential(String credential) {
            this.object.setBindCredential(new Credential(credential));
            return this;
        }

        public Builder credential(byte[] credential) {
            this.object.setBindCredential(new Credential(credential));
            return this;
        }

        public Builder saslConfig(SaslConfig config) {
            this.object.setBindSaslConfig(config);
            return this;
        }

        public Builder controls(RequestControl ... controls) {
            this.object.setBindControls(controls);
            return this;
        }

        public BindConnectionInitializer build() {
            return this.object;
        }
    }
}

