/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RenderAction
extends AbstractAction {
    private Expression[] fragmentExpressions;

    public RenderAction(Expression ... fragmentExpressions) {
        if (fragmentExpressions == null || fragmentExpressions.length == 0) {
            throw new IllegalArgumentException("You must provide at least one fragment expression to this render action");
        }
        this.fragmentExpressions = fragmentExpressions;
    }

    @Override
    protected Event doExecute(RequestContext context) throws Exception {
        String[] fragments = new String[this.fragmentExpressions.length];
        for (int i = 0; i < this.fragmentExpressions.length; ++i) {
            Expression exp = this.fragmentExpressions[i];
            fragments[i] = (String)exp.getValue((Object)context);
        }
        context.getFlashScope().put("flowRenderFragments", fragments);
        return this.success();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("fragments", (Object)this.fragmentExpressions).toString();
    }
}

