/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;

public class ResponseData {
    @Nonnull
    private Response response;
    @Nonnull
    private InOutOperationContext soapClientContext;
    @Nonnull
    private AttributeResolutionContext attributeResolutionContext;
    @Nonnull
    private Map<String, List<IdPAttributeValue>> dependencyAttributes;
    @Nonnull
    private RoleDescriptor attributeAuthorityRoleDescriptor;

    public ResponseData(@Nonnull Response message, @Nonnull InOutOperationContext soapContext, @Nonnull AttributeResolutionContext attributeContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencies, @Nonnull RoleDescriptor roleDescriptor) {
        this.response = (Response)Constraint.isNotNull((Object)message, (String)"Response message was null");
        this.soapClientContext = (InOutOperationContext)Constraint.isNotNull((Object)soapContext, (String)"SOAP client operation context was null");
        this.attributeResolutionContext = (AttributeResolutionContext)((Object)Constraint.isNotNull((Object)((Object)attributeContext), (String)"Attribute resolution context was null"));
        this.dependencyAttributes = (Map)Constraint.isNotNull(dependencies, (String)"Dependency attributes were null");
        this.attributeAuthorityRoleDescriptor = (RoleDescriptor)Constraint.isNotNull((Object)roleDescriptor, (String)"RoleDescriptor was null");
    }

    @Nonnull
    public Response getResponse() {
        return this.response;
    }

    @Nonnull
    public InOutOperationContext getSOAPClientContext() {
        return this.soapClientContext;
    }

    @Nonnull
    public AttributeResolutionContext getAttributeResolutionContext() {
        return this.attributeResolutionContext;
    }

    @Nonnull
    public Map<String, List<IdPAttributeValue>> getDependencyAttributes() {
        return this.dependencyAttributes;
    }

    @Nonnull
    public RoleDescriptor getAttributeAuthorityRoleDescriptor() {
        return this.attributeAuthorityRoleDescriptor;
    }
}

