/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.MultipleResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.AbstractMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.ldap.SearchResultMappingStrategy;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;

public class StringAttributeValueMappingStrategy
extends AbstractMappingStrategy<SearchResponse>
implements SearchResultMappingStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StringAttributeValueMappingStrategy.class);

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> map(@Nonnull SearchResponse results) throws ResolutionException {
        Constraint.isNotNull((Object)results, (String)"Results can not be null");
        if (results.entrySize() == 0) {
            this.log.debug("Results did not contain any entries, nothing to map");
            if (this.isNoResultAnError()) {
                throw new NoResultAnErrorResolutionException("No entries returned from search");
            }
            return null;
        }
        if (results.entrySize() > 1 && this.isMultipleResultsAnError()) {
            throw new MultipleResultAnErrorResolutionException("Multiple entries returned from search");
        }
        HashMap<String, IdPAttribute> attributes = new HashMap<String, IdPAttribute>(results.entrySize());
        Map<String, String> aliases = this.getResultRenamingMap();
        for (LdapEntry entry : results.getEntries()) {
            for (LdapAttribute attr : entry.getAttributes()) {
                IdPAttribute attribute;
                String effectiveId;
                String originalId = attr.getName();
                String string = effectiveId = aliases.containsKey(originalId) ? aliases.get(originalId) : originalId;
                assert (effectiveId != null);
                if (this.log.isDebugEnabled() && !effectiveId.equals(originalId)) {
                    this.log.debug("Remapping attribute {} to {}", (Object)originalId, (Object)effectiveId);
                }
                if ((attribute = (IdPAttribute)attributes.get(effectiveId)) == null) {
                    attribute = new IdPAttribute(effectiveId);
                    attributes.put(effectiveId, attribute);
                }
                ArrayList<IdPAttributeValue> values = new ArrayList<IdPAttributeValue>(attr.getStringValues().size() + attribute.getValues().size());
                values.addAll(attribute.getValues());
                for (String value : attr.getStringValues()) {
                    values.add(StringAttributeValue.valueOf((String)value));
                }
                attribute.setValues(values);
            }
        }
        this.log.trace("Mapping strategy mapped {} to {}", (Object)results, attributes);
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }
}

