/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.ldap.AbstractExecutableSearchFilterBuilder;
import net.shibboleth.idp.attribute.resolver.dc.ldap.ExecutableSearchFilter;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.ldaptive.FilterTemplate;

public class ParameterizedExecutableSearchFilterBuilder
extends AbstractExecutableSearchFilterBuilder {
    @NonnullAfterInit
    private String searchFilter;

    public void setSearchFilter(@Nonnull String filter) {
        this.checkSetterPreconditions();
        this.searchFilter = (String)Constraint.isNotNull((Object)filter, (String)"Search filter can not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.searchFilter == null) {
            throw new ComponentInitializationException("Search filter cannot be null");
        }
    }

    @Override
    @Nonnull
    public ExecutableSearchFilter build(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        this.checkComponentActive();
        FilterTemplate sf = new FilterTemplate(this.searchFilter);
        sf.setParameter("principalName", (Object)resolutionContext.getPrincipal());
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue>> entry : dependencyAttributes.entrySet()) {
                int i = 0;
                for (IdPAttributeValue value : entry.getValue()) {
                    if (i == 0) {
                        sf.setParameter(String.format("%s", entry.getKey(), i), value.getNativeValue());
                    }
                    sf.setParameter(String.format("%s[%s]", entry.getKey(), i++), value.getNativeValue());
                }
            }
        }
        return super.build(sf);
    }
}

