/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.context;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@NotThreadSafe
public final class AttributeResolutionContext
extends BaseContext {
    @Nonnull
    private Set<String> requestedAttributeNames;
    @Nonnull
    private Function<AttributeResolutionContext, ProfileRequestContext> prcLookupStrategy = new ParentContextLookup(ProfileRequestContext.class);
    @Nullable
    private String principal;
    @Nullable
    private String attributeIssuerID;
    @Nullable
    private String attributeRecipientID;
    @Nullable
    private String attributeRecipientGroupID;
    private boolean allowCachedResults = true;
    @Nullable
    private String resolutionLabel;
    @Nonnull
    private Map<String, IdPAttribute> resolvedAttributes;

    public AttributeResolutionContext() {
        this.requestedAttributeNames = new HashSet<String>();
        this.resolvedAttributes = CollectionSupport.emptyMap();
    }

    @Nonnull
    public Function<AttributeResolutionContext, ProfileRequestContext> getProfileRequestContextLookupStrategy() {
        return this.prcLookupStrategy;
    }

    @Nonnull
    public AttributeResolutionContext setProfileRequestContextLookupStrategy(@Nonnull Function<AttributeResolutionContext, ProfileRequestContext> strategy) {
        this.prcLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
        return this;
    }

    public boolean getAllowCachedResults() {
        return this.allowCachedResults;
    }

    @Nonnull
    public AttributeResolutionContext setAllowCachedResults(boolean flag) {
        this.allowCachedResults = flag;
        return this;
    }

    @Nullable
    public String getResolutionLabel() {
        return this.resolutionLabel;
    }

    @Nonnull
    public AttributeResolutionContext setResolutionLabel(@Nullable String label) {
        this.resolutionLabel = StringSupport.trimOrNull((String)label);
        return this;
    }

    @Nullable
    public String getAttributeIssuerID() {
        return this.attributeIssuerID;
    }

    @Nonnull
    public AttributeResolutionContext setAttributeIssuerID(@Nullable String value) {
        this.attributeIssuerID = value;
        return this;
    }

    @Nullable
    public String getAttributeRecipientID() {
        return this.attributeRecipientID;
    }

    @Nonnull
    public AttributeResolutionContext setAttributeRecipientID(@Nullable String value) {
        this.attributeRecipientID = value;
        return this;
    }

    @Nullable
    public String getAttributeRecipientGroupID() {
        return this.attributeRecipientGroupID;
    }

    @Nonnull
    public AttributeResolutionContext setAttributeRecipientGroupID(@Nullable String value) {
        this.attributeRecipientGroupID = value;
        return this;
    }

    @Nullable
    public String getPrincipal() {
        return this.principal;
    }

    @Nonnull
    public AttributeResolutionContext setPrincipal(@Nullable String who) {
        this.principal = who;
        return this;
    }

    @Nonnull
    @Live
    public Collection<String> getRequestedIdPAttributeNames() {
        return this.requestedAttributeNames;
    }

    @Nonnull
    public AttributeResolutionContext setRequestedIdPAttributeNames(@Nonnull Collection<String> names) {
        this.requestedAttributeNames = (Set)((NonnullSupplier)((Collection)Constraint.isNotNull(names, (String)"Requested IdPAttribute collection cannot be null")).stream().collect(CollectionSupport.nonnullCollector(Collectors.toCollection(HashSet::new)))).get();
        return this;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getResolvedIdPAttributes() {
        return this.resolvedAttributes;
    }

    @Nonnull
    public AttributeResolutionContext setResolvedIdPAttributes(@Nonnull Collection<IdPAttribute> attributes) {
        Constraint.isNotNull(attributes, (String)"Null attribute set cannot be inserted into a context");
        this.resolvedAttributes = (Map)((NonnullSupplier)attributes.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(IdPAttribute::getId, a -> a, CollectionSupport.warningMergeFunction((String)"AttrtibuteResolutionContext", (boolean)true))))).get();
        return this;
    }

    public void resolveAttributes(@Nonnull ReloadableService<AttributeResolver> attributeResolverService) {
        Logger log = LoggerFactory.getLogger(AttributeResolutionContext.class);
        try (ServiceableComponent component = attributeResolverService.getServiceableComponent();){
            AttributeResolver attributeResolver = (AttributeResolver)component.getComponent();
            attributeResolver.resolveAttributes(this);
        }
        catch (ResolutionException e) {
            log.error("Error resolving attributes", (Throwable)e);
        }
        catch (ServiceException e) {
            log.error("Invalid AttributeResolver configuration", (Throwable)e);
        }
    }
}

