/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.resolver.MultipleResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.MetricContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;

@ThreadSafe
public abstract class AbstractResolverPlugin<ResolvedType>
extends AbstractIdentifiableInitializableComponent
implements ResolverPlugin<ResolvedType>,
DisposableBean {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractResolverPlugin.class);
    private boolean propagateResolutionExceptions = true;
    @Nullable
    private Predicate<ProfileRequestContext> activationCondition;
    @Nonnull
    private Set<ResolverAttributeDefinitionDependency> attributeDependencies = CollectionSupport.emptySet();
    @Nonnull
    private Set<ResolverDataConnectorDependency> dataConnectorDependencies = CollectionSupport.emptySet();

    @Override
    public boolean isPropagateResolutionExceptions() {
        return this.propagateResolutionExceptions;
    }

    public void setPropagateResolutionExceptions(boolean propagate) {
        this.checkSetterPreconditions();
        this.propagateResolutionExceptions = propagate;
    }

    @Override
    @Nullable
    public Predicate<ProfileRequestContext> getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> pred) {
        this.checkSetterPreconditions();
        this.activationCondition = (Predicate)Constraint.isNotNull(pred, (String)"Activation condition cannot be null");
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<ResolverAttributeDefinitionDependency> getAttributeDependencies() {
        return this.attributeDependencies;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<ResolverDataConnectorDependency> getDataConnectorDependencies() {
        return this.dataConnectorDependencies;
    }

    public void setAttributeDependencies(@Nonnull Set<ResolverAttributeDefinitionDependency> dependencies) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(dependencies, (String)"Attribute Dependencies cannot be null");
        this.attributeDependencies = CollectionSupport.copyToSet(dependencies);
    }

    public void setDataConnectorDependencies(@Nonnull Set<ResolverDataConnectorDependency> dependencies) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(dependencies, (String)"DataConnector Dependencies cannot be null");
        this.dataConnectorDependencies = CollectionSupport.copyToSet(dependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final ResolvedType resolve(@Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        this.checkComponentActive();
        Constraint.isNotNull((Object)((Object)resolutionContext), (String)"AttributeResolutionContext cannot be null");
        boolean timerStarted = this.startTimer(resolutionContext);
        try {
            ResolvedType ResolvedType;
            if (null != this.activationCondition) {
                ProfileRequestContext profileRequestContext = resolutionContext.getProfileRequestContextLookupStrategy().apply(resolutionContext);
                assert (this.activationCondition != null);
                if (!this.activationCondition.test(profileRequestContext)) {
                    this.log.debug("Resolver plugin '{}': activation criteria not met, nothing to do", (Object)this.getId());
                    ResolvedType ResolvedType2 = null;
                    return ResolvedType2;
                }
            }
            AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class);
            try {
                if (workContext == null) {
                    throw new ResolutionException("AttributeResolverWorkContext cannot be null");
                }
                ResolvedType result = this.doResolve(resolutionContext, workContext);
                if (null == result) {
                    this.log.debug("Resolver plugin '{}' produced no value.", (Object)this.getId());
                }
                ResolvedType = result;
            }
            catch (ResolutionException e) {
                ResolvedType ResolvedType3;
                block16: {
                    if (this.propagateResolutionExceptions) {
                        throw e;
                    }
                    if (e instanceof NoResultAnErrorResolutionException || e instanceof MultipleResultAnErrorResolutionException) {
                        this.log.debug("Resolver plugin '{}' produced the following error but was configured not to propagate", (Object)this.getId(), (Object)e);
                    } else {
                        this.log.warn("Resolver plugin '{}' produced the following error but was configured not to propagate", (Object)this.getId(), (Object)e);
                    }
                    ResolvedType3 = null;
                    if (!timerStarted) break block16;
                    this.stopTimer(resolutionContext);
                }
                return ResolvedType3;
            }
            return ResolvedType;
        }
        finally {
            if (timerStarted) {
                this.stopTimer(resolutionContext);
            }
        }
    }

    protected void doDestroy() {
        this.attributeDependencies = CollectionSupport.emptySet();
        this.dataConnectorDependencies = CollectionSupport.emptySet();
        super.doDestroy();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractResolverPlugin)) {
            return false;
        }
        AbstractResolverPlugin other = (AbstractResolverPlugin)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    @Nullable
    protected abstract ResolvedType doResolve(@Nonnull AttributeResolutionContext var1, @Nonnull AttributeResolverWorkContext var2) throws ResolutionException;

    private boolean startTimer(@Nonnull AttributeResolutionContext resolutionContext) {
        MetricContext timerCtx;
        ProfileRequestContext prc = resolutionContext.getProfileRequestContextLookupStrategy().apply(resolutionContext);
        if (prc != null && (timerCtx = (MetricContext)prc.getSubcontext(MetricContext.class)) != null) {
            timerCtx.start(this.ensureId());
            return true;
        }
        return false;
    }

    private void stopTimer(@Nonnull AttributeResolutionContext resolutionContext) {
        MetricContext timerCtx;
        ProfileRequestContext prc = resolutionContext.getProfileRequestContextLookupStrategy().apply(resolutionContext);
        if (prc != null && (timerCtx = (MetricContext)prc.getSubcontext(MetricContext.class)) != null) {
            timerCtx.stop(this.ensureId());
        }
    }

    @Nonnull
    @NotEmpty
    protected abstract String getLogPrefix();
}

