/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.messaging.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SelectProfileConfiguration
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectProfileConfiguration.class);
    @NonnullAfterInit
    private Function<MessageContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Function<MessageContext, ProfileRequestContext> profileRequestContextLookupStrategy = new RecursiveTypedParentContextLookup(ProfileRequestContext.class);
    @NonnullAfterInit
    private Function<MessageContext, String> profileIdLookupStrategy;
    @Nullable
    private RelyingPartyContext rpCtx;

    public SelectProfileConfiguration() {
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class).compose((Function)new RecursiveTypedParentContextLookup(InOutOperationContext.class));
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<MessageContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Nonnull
    public Function<MessageContext, ProfileRequestContext> getProfileRequestContextLookupStrategy() {
        return this.profileRequestContextLookupStrategy;
    }

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<MessageContext, ProfileRequestContext> strategy) {
        this.profileRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    public void setProfiledIdLookupStrategy(@Nonnull Function<MessageContext, String> strategy) {
        this.checkSetterPreconditions();
        this.profileIdLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.profileIdLookupStrategy == null) {
            throw new ComponentInitializationException("Profile ID lookup strategy was null");
        }
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.rpCtx = this.relyingPartyContextLookupStrategy.apply(messageContext);
        RelyingPartyContext ctx = this.rpCtx;
        if (ctx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No relying party context associated with this message context");
        }
        if (ctx.getConfiguration() == null) {
            this.log.debug("{} No relying party configuration associated with this profile request", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No relying party configuration associated with this message context");
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        RelyingPartyContext ctx = this.rpCtx;
        assert (ctx != null);
        RelyingPartyConfiguration rpConfig = ctx.getConfiguration();
        assert (rpConfig != null);
        String profileId = this.profileIdLookupStrategy.apply(messageContext);
        if (profileId == null) {
            this.log.warn("{} Profile ID is not available from message context for RP configuration (RPID {})", new Object[]{this.getLogPrefix(), rpConfig.getId(), ctx.getRelyingPartyId()});
            throw new MessageHandlerException("Profile ID is not available from message context");
        }
        ProfileConfiguration profileConfiguration = rpConfig.getProfileConfiguration(this.profileRequestContextLookupStrategy.apply(messageContext), profileId);
        if (profileConfiguration == null) {
            this.log.warn("{} Profile {} is not available for RP configuration {} (RPID {})", new Object[]{this.getLogPrefix(), profileId, rpConfig.getId(), ctx.getRelyingPartyId()});
            throw new MessageHandlerException("Profile is not available for RP configuration");
        }
        ctx.setProfileConfig(profileConfiguration);
    }
}

