/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.security.credential;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.custom.AbstractCustomBeanDefinitionParser;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractCredentialParser
extends AbstractCustomBeanDefinitionParser {
    @Nonnull
    public static final QName CREDENTIAL_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:security", "Credential");
    @Nonnull
    public static final QName KEY_NAME_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:security", "KeyName");

    @Nonnull
    @NotEmpty
    protected String resolveId(@Nonnull Element element, @Nonnull AbstractBeanDefinition definition, @Nonnull ParserContext parserContext) {
        return AttributeSupport.ensureAttributeValue((Element)element, null, (String)"id");
    }

    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        builder.setLazyInit(true);
        this.parseAttributes(element, builder);
        this.parseKeyNames(ElementSupport.getChildElements((Node)element, (QName)KEY_NAME_ELEMENT_NAME), builder);
    }

    protected void parseAttributes(@Nonnull Element element, @Nonnull BeanDefinitionBuilder builder) {
        String usage = StringSupport.trimOrNull((String)element.getAttributeNS(null, "usage"));
        builder.addPropertyValue("usageType", (Object)usage);
        String entityID = StringSupport.trimOrNull((String)element.getAttributeNS(null, "entityID"));
        if (entityID != null) {
            builder.addPropertyValue("entityID", (Object)entityID);
        }
    }

    protected void parseKeyNames(@Nullable List<Element> keyNameElems, @Nonnull BeanDefinitionBuilder builder) {
        if (keyNameElems == null || keyNameElems.isEmpty()) {
            return;
        }
        builder.addPropertyValue("keyNames", (Object)SpringSupport.getElementTextContentAsManagedList(keyNameElems));
    }
}

