/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata.filter;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.metadata.impl.ScopeFilter;
import net.shibboleth.idp.saml.xmlobject.Scope;
import net.shibboleth.shared.logic.ScriptedPredicate;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.ScriptTypeBeanParser;
import net.shibboleth.spring.metadata.filter.AbstractMetadataFilterParser;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.profile.logic.EntityIdPredicate;
import org.opensaml.saml.common.profile.logic.EntityRegexPredicate;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScopeFilterParser
extends AbstractMetadataFilterParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "Scope");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScopeFilterParser.class);

    @Nonnull
    protected Class<?> getBeanClass(@Nonnull Element element) {
        return ScopeFilter.class;
    }

    @Override
    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        ManagedList forRule;
        BeanDefinitionBuilder entityIdBuilder;
        Unmarshaller scopeUnmarshaller;
        super.doParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "removeExistingScopes")) {
            builder.addPropertyValue("removeExistingScopes", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "removeExistingScopes")));
        }
        if ((scopeUnmarshaller = XMLObjectSupport.getUnmarshaller((QName)Scope.DEFAULT_ELEMENT_NAME)) == null) {
            throw new BeanCreationException("Unable to obtain Scope Unmarshaller");
        }
        ArrayList<XMLObject> accumulator = new ArrayList<XMLObject>();
        ManagedMap ruleMap = new ManagedMap();
        ManagedSet entitySet = new ManagedSet();
        Element child = ElementSupport.getFirstChildElement((Node)element);
        while (child != null) {
            if (ElementSupport.isElementNamed((Element)child, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Entity")) {
                entitySet.add((Object)ElementSupport.getElementContentAsString((Element)child));
                child = ElementSupport.getNextSiblingElement((Node)child);
                continue;
            }
            if (!entitySet.isEmpty()) {
                entityIdBuilder = BeanDefinitionBuilder.genericBeanDefinition(EntityIdPredicate.class);
                entityIdBuilder.addConstructorArgValue((Object)entitySet);
                forRule = new ManagedList(accumulator.size());
                forRule.addAll(accumulator);
                ruleMap.put((Object)entityIdBuilder.getBeanDefinition(), (Object)forRule);
                entitySet = new ManagedSet();
            }
            if (ElementSupport.isElementNamed((Element)child, (QName)Scope.DEFAULT_ELEMENT_NAME)) {
                try {
                    accumulator.add(scopeUnmarshaller.unmarshall(child));
                }
                catch (UnmarshallingException e) {
                    this.log.error("Error unmarshalling DigestMethod element", (Throwable)e);
                }
            } else if (ElementSupport.isElementNamed((Element)child, (String)"urn:mace:shibboleth:2.0:metadata", (String)"EntityRegex")) {
                forRule = new ManagedList(accumulator.size());
                forRule.addAll(accumulator);
                BeanDefinitionBuilder expBuilder = BeanDefinitionBuilder.genericBeanDefinition(EntityRegexPredicate.class);
                expBuilder.addConstructorArgValue((Object)ElementSupport.getElementContentAsString((Element)child));
                ruleMap.put((Object)expBuilder.getBeanDefinition(), (Object)forRule);
            } else if (ElementSupport.isElementNamed((Element)child, (String)"urn:mace:shibboleth:2.0:metadata", (String)"ConditionRef")) {
                forRule = new ManagedList(accumulator.size());
                forRule.addAll(accumulator);
                ruleMap.put((Object)new RuntimeBeanReference(ElementSupport.getElementContentAsString((Element)child)), (Object)forRule);
            } else if (ElementSupport.isElementNamed((Element)child, (String)"urn:mace:shibboleth:2.0:metadata", (String)"ConditionScript")) {
                forRule = new ManagedList(accumulator.size());
                forRule.addAll(accumulator);
                ruleMap.put((Object)ScriptTypeBeanParser.parseScriptType(ScriptedPredicate.class, child).getBeanDefinition(), (Object)forRule);
            }
            child = ElementSupport.getNextSiblingElement((Node)child);
        }
        if (!entitySet.isEmpty()) {
            entityIdBuilder = BeanDefinitionBuilder.genericBeanDefinition(EntityIdPredicate.class);
            entityIdBuilder.addConstructorArgValue((Object)entitySet);
            forRule = new ManagedList(accumulator.size());
            forRule.addAll(accumulator);
            ruleMap.put((Object)entityIdBuilder.getBeanDefinition(), (Object)forRule);
        }
        builder.addPropertyValue("rules", (Object)ruleMap);
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

