/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata.filter;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.metadata.filter.AbstractMetadataFilterParser;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.impl.ByReferenceMetadataFilter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ByReferenceParser
extends AbstractMetadataFilterParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "ByReference");

    @Nonnull
    protected Class<?> getBeanClass(@Nonnull Element element) {
        return ByReferenceMetadataFilter.class;
    }

    @Override
    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        List children = ElementSupport.getChildElements((Node)element, (QName)new QName("urn:mace:shibboleth:2.0:metadata", "MetadataFilters"));
        if (null != children && !children.isEmpty()) {
            ManagedMap mappings = new ManagedMap();
            for (Element child : children) {
                assert (child != null);
                List filters = ElementSupport.getChildElements((Node)child, (QName)new QName("urn:mace:shibboleth:2.0:metadata", "MetadataFilter"));
                if (filters == null || filters.isEmpty()) continue;
                AbstractBeanDefinition providerRef = SpringSupport.getAttributeValueAsList((Attr)child.getAttributeNodeNS(null, "providerRef"));
                ManagedList filterBeans = SpringSupport.parseCustomElements((Collection)filters, (ParserContext)parserContext, (BeanDefinitionBuilder)builder);
                if (filterBeans == null) continue;
                if (filterBeans.size() == 1) {
                    mappings.put((Object)providerRef, (Object)((BeanDefinition)filterBeans.get(0)));
                    continue;
                }
                BeanDefinitionBuilder chain = BeanDefinitionBuilder.genericBeanDefinition(MetadataFilterChain.class);
                chain.addPropertyValue("filters", (Object)filterBeans);
                mappings.put((Object)providerRef, (Object)chain.getBeanDefinition());
            }
            builder.addPropertyValue("filterMappings", (Object)mappings);
        }
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

