/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.spring.metadata.AbstractDynamicMetadataProviderParser;
import org.opensaml.core.xml.persist.FilesystemLoadSaveManager;
import org.opensaml.core.xml.persist.impl.PassthroughSourceStrategy;
import org.opensaml.core.xml.persist.impl.SegmentingIntermediateDirectoryStrategy;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DefaultLocalDynamicSourceKeyGenerator;
import org.opensaml.saml.metadata.resolver.impl.LocalDynamicMetadataResolver;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class LocalDynamicMetadataProviderParser
extends AbstractDynamicMetadataProviderParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "LocalDynamicMetadataProvider");
    @Nonnull
    private Logger log = LoggerFactory.getLogger(LocalDynamicMetadataProviderParser.class);

    @Override
    @Nonnull
    protected Class<? extends MetadataResolver> getNativeBeanClass(@Nonnull Element element) {
        return LocalDynamicMetadataResolver.class;
    }

    @Override
    protected void doNativeParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        String sourceKeyGeneratorRefOrBean = null;
        if (element.hasAttributeNS(null, "sourceKeyGeneratorRef")) {
            sourceKeyGeneratorRefOrBean = StringSupport.trimOrNull((String)element.getAttributeNS(null, "sourceKeyGeneratorRef"));
        }
        String sourceManagerRefOrBean = null;
        if (element.hasAttributeNS(null, "sourceManagerRef")) {
            sourceManagerRefOrBean = StringSupport.trimOrNull((String)element.getAttributeNS(null, "sourceManagerRef"));
            this.checkAndLogSourceDirectoryOverrides(element);
        } else if (element.hasAttributeNS(null, "sourceDirectory")) {
            boolean isDefaultSourceKeyGenerator = false;
            if (sourceKeyGeneratorRefOrBean == null) {
                sourceKeyGeneratorRefOrBean = new DefaultLocalDynamicSourceKeyGenerator(null, ".xml", null);
                isDefaultSourceKeyGenerator = true;
            }
            sourceManagerRefOrBean = this.buildFilesystemManagerDefinition(element, parserContext, isDefaultSourceKeyGenerator);
        } else {
            this.log.error("{} LocalDynamicMetadataProvider contained neither a sourceManagerRef nor a sourceDirectory", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("Neither a sourceManagerRef nor sourceDirectory was supplied", new Location(parserContext.getReaderContext().getResource())));
        }
        if (sourceManagerRefOrBean instanceof String) {
            builder.addConstructorArgReference(sourceManagerRefOrBean);
        } else {
            builder.addConstructorArgValue((Object)sourceManagerRefOrBean);
        }
        if (sourceKeyGeneratorRefOrBean instanceof String) {
            builder.addConstructorArgReference(sourceKeyGeneratorRefOrBean);
        } else {
            builder.addConstructorArgValue((Object)sourceKeyGeneratorRefOrBean);
        }
    }

    private void checkAndLogSourceDirectoryOverrides(@Nonnull Element element) {
        if (element.hasAttributeNS(null, "sourceDirectory")) {
            this.log.warn("Presence of sourceManagerRef will override sourceDirectory");
        }
        if (element.hasAttributeNS(null, "sourceDirectoryIntermediateSegmentNumber") || element.hasAttributeNS(null, "sourceDirectoryIntermediateSegmentLength") || element.hasAttributeNS(null, "sourceDirectoryIntermediateStrategyRef")) {
            this.log.warn("Presence of sourceManagerRef will override sourceDirectoryIntermediateSegmentNumber, sourceDirectoryIntermediateSegmentLength and sourceDirectoryIntermediateStrategyRef");
        }
    }

    @Nonnull
    private BeanDefinition buildFilesystemManagerDefinition(@Nonnull Element element, @Nonnull ParserContext parserContext, boolean isDefaultSourceKeyGenerator) {
        BeanDefinitionBuilder sourceManagerBuilder = BeanDefinitionBuilder.genericBeanDefinition(FilesystemLoadSaveManager.class);
        sourceManagerBuilder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "sourceDirectory")));
        sourceManagerBuilder.addConstructorArgValue((Object)Boolean.TRUE);
        this.processIntermediateDirectoryStrategy(element, parserContext, sourceManagerBuilder, isDefaultSourceKeyGenerator);
        return sourceManagerBuilder.getBeanDefinition();
    }

    private void processIntermediateDirectoryStrategy(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder sourceManagerBuilder, boolean isDefaultSourceKeyGenerator) {
        if (element.hasAttributeNS(null, "sourceDirectoryIntermediateStrategyRef")) {
            sourceManagerBuilder.addConstructorArgReference(AttributeSupport.ensureAttributeValue((Element)element, null, (String)"sourceDirectoryIntermediateStrategyRef"));
        } else if (isDefaultSourceKeyGenerator) {
            BeanDefinition intermediateDirectoryStrategy = this.checkAndBuildPassthroughIntermediateDirectoryStrategy(element, parserContext);
            if (intermediateDirectoryStrategy != null) {
                sourceManagerBuilder.addConstructorArgValue((Object)intermediateDirectoryStrategy);
            }
        } else if (element.hasAttributeNS(null, "sourceDirectoryIntermediateSegmentNumber") || element.hasAttributeNS(null, "sourceDirectoryIntermediateSegmentLength")) {
            this.log.warn("{} Non-default source key manger in use, sourceDirectoryIntermediateSegmentNumber and sourceDirectoryIntermediateSegmentLength will be ignored. Use sourceDirectoryIntermediateStrategyRef instead");
        }
    }

    @Nullable
    private BeanDefinition checkAndBuildPassthroughIntermediateDirectoryStrategy(@Nonnull Element element, @Nonnull ParserContext parserContext) {
        if (!element.hasAttributeNS(null, "sourceDirectoryIntermediateSegmentNumber") && !element.hasAttributeNS(null, "sourceDirectoryIntermediateSegmentLength")) {
            return null;
        }
        if (!element.hasAttributeNS(null, "sourceDirectoryIntermediateSegmentNumber") || !element.hasAttributeNS(null, "sourceDirectoryIntermediateSegmentLength")) {
            this.log.error("{} LocalDynamicMetadataProvider contained either sourceDirectoryIntermediateSegmentNumber or sourceDirectoryIntermediateSegmentLength without the other", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("Either sourceDirectoryIntermediateSegmentNumber or sourceDirectoryIntermediateSegmentLength was supplied without the other", new Location(parserContext.getReaderContext().getResource())));
        }
        BeanDefinitionBuilder strategyBuilder = BeanDefinitionBuilder.genericBeanDefinition(SegmentingIntermediateDirectoryStrategy.class);
        strategyBuilder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "sourceDirectoryIntermediateSegmentNumber")));
        strategyBuilder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "sourceDirectoryIntermediateSegmentLength")));
        strategyBuilder.addConstructorArgValue((Object)new PassthroughSourceStrategy());
        return strategyBuilder.getBeanDefinition();
    }
}

