/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class ServiceNameTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 2131709003267781456L;
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(ServiceNameTag.class);
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_VALUE = "Unspecified Service Provider";
    @Nullable
    private String defaultValue;

    public void setDefaultValue(@Nullable String value) {
        this.defaultValue = value;
    }

    public int doStartTag() throws JspException {
        try {
            String rawServiceName = this.getServiceName();
            String serviceName = HTMLEncoder.encodeForHTML((String)rawServiceName);
            if (null == serviceName) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                boolean written = false;
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                    written = true;
                }
                if (!written) {
                    this.pageContext.getOut().print(this.defaultValue != null ? this.defaultValue : DEFAULT_VALUE);
                }
            } else {
                this.pageContext.getOut().print(serviceName);
            }
        }
        catch (IOException e) {
            log.warn("Error generating name: {}", (Object)e.getMessage());
            throw new JspException("StartTag", (Throwable)e);
        }
        return super.doStartTag();
    }
}

