/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.encoder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.UnmodifiableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.slf4j.Logger;

public abstract class AbstractMessageEncoder
extends AbstractInitializableComponent
implements MessageEncoder,
UnmodifiableComponent {
    @Nonnull
    public static final String BASE_PROTOCOL_MESSAGE_LOGGER_CATEGORY = "PROTOCOL_MESSAGE";
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractMessageEncoder.class);
    @NonnullAfterInit
    private MessageContext messageContext;
    @Nullable
    private String protocolMessageLoggerSubCategory;

    @Override
    public synchronized void setMessageContext(@Nullable MessageContext context) {
        this.checkSetterPreconditions();
        this.messageContext = context;
    }

    @Override
    public void prepareContext() throws MessageEncodingException {
    }

    @NonnullAfterInit
    protected MessageContext getMessageContext() {
        return this.messageContext;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.messageContext == null) {
            throw new ComponentInitializationException("Message context cannot be null");
        }
    }

    @Override
    public void encode() throws MessageEncodingException {
        this.checkComponentActive();
        this.doEncode();
        this.logEncodedMessage();
    }

    @Nonnull
    protected Logger getProtocolMessageLogger() {
        return this.protocolMessageLog;
    }

    @Nullable
    protected String getProtocolMessageLoggerSubCategory() {
        return this.protocolMessageLoggerSubCategory;
    }

    protected void setProtocolMessageLoggerSubCategory(@Nullable String category) {
        this.protocolMessageLoggerSubCategory = StringSupport.trimOrNull((String)category);
        this.protocolMessageLog = this.protocolMessageLoggerSubCategory != null ? LoggerFactory.getLogger((String)("PROTOCOL_MESSAGE." + this.protocolMessageLoggerSubCategory)) : LoggerFactory.getLogger((String)BASE_PROTOCOL_MESSAGE_LOGGER_CATEGORY);
    }

    protected void logEncodedMessage() {
        if (this.protocolMessageLog.isDebugEnabled()) {
            String serializedMessage = this.serializeMessageForLogging(this.getMessageToLog());
            if (serializedMessage == null) {
                this.log.debug("Serialized encoded protocol message was null, nothing to log");
                return;
            }
            this.protocolMessageLog.debug("\n" + serializedMessage);
        }
    }

    @Nullable
    protected Object getMessageToLog() {
        MessageContext mc = this.getMessageContext();
        return mc != null ? mc.getMessage() : null;
    }

    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        return message != null ? message.toString() : null;
    }

    protected abstract void doEncode() throws MessageEncodingException;
}

