/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.saml.impl.AbstractNameIDFormatExactPolicyRule;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.slf4j.Logger;

public class IssuerNameIDFormatExactPolicyRule
extends AbstractNameIDFormatExactPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IssuerNameIDFormatExactPolicyRule.class);

    @Override
    @Nullable
    protected SSODescriptor getEntitySSODescriptor(@Nonnull AttributeFilterContext filterContext) {
        SAMLMetadataContext metadataContext = filterContext.getIssuerMetadataContext();
        if (null == metadataContext) {
            this.log.debug("{} No requester metadata context found", (Object)this.getLogPrefix());
            return null;
        }
        RoleDescriptor role = metadataContext.getRoleDescriptor();
        if (null == role) {
            this.log.warn("{} Could not locate RoleDescriptor in requester metadata context", (Object)this.getLogPrefix());
            return null;
        }
        if (role instanceof SSODescriptor) {
            return (SSODescriptor)role;
        }
        this.log.warn("{} Located Role descriptor was of type {} and so could not be used", (Object)this.getLogPrefix(), (Object)role.getClass().toString());
        return null;
    }
}

