/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.filtercontext.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PredicatePolicyRule
extends AbstractPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PredicatePolicyRule.class);
    @NonnullAfterInit
    private Predicate<ProfileRequestContext> rulePredicate;

    @NonnullAfterInit
    public Predicate<ProfileRequestContext> getRulePredicate() {
        return this.rulePredicate;
    }

    public void setRulePredicate(@Nullable Predicate<ProfileRequestContext> predicate) {
        this.rulePredicate = predicate;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.getRulePredicate()) {
            throw new ComponentInitializationException("Provided Rule Predicate was null");
        }
    }

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        this.checkComponentActive();
        ProfileRequestContext pc = (ProfileRequestContext)filterContext.getProfileRequestContextLookupStrategy().apply(filterContext);
        if (null == pc) {
            this.log.warn("{} Could not locate profile context", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FAIL;
        }
        try {
            if (this.rulePredicate.test(pc)) {
                this.log.trace("{} Predicate returned false", (Object)this.getLogPrefix());
                return PolicyRequirementRule.Tristate.TRUE;
            }
            this.log.trace("{} Predicate returned false", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        catch (Throwable ex) {
            this.log.warn("{} Applying the predicate failed", (Object)this.getLogPrefix(), (Object)ex);
            return PolicyRequirementRule.Tristate.FAIL;
        }
    }
}

