/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.saml.impl;

import com.google.common.collect.Multimap;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.slf4j.Logger;

public class AttributeInMetadataMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeInMetadataMatcher.class);
    private boolean onlyIfRequired = true;
    private boolean matchIfMetadataSilent;
    @Nullable
    @NotEmpty
    private String attributeName;
    @Nullable
    @NotEmpty
    private String attributeNameFormat;
    @Nullable
    @NotEmpty
    private String logPrefix;

    public boolean getOnlyIfRequired() {
        return this.onlyIfRequired;
    }

    public void setOnlyIfRequired(boolean flag) {
        this.checkSetterPreconditions();
        this.onlyIfRequired = flag;
    }

    public boolean getMatchIfMetadataSilent() {
        return this.matchIfMetadataSilent;
    }

    public void setMatchIfMetadataSilent(boolean flag) {
        this.checkSetterPreconditions();
        this.matchIfMetadataSilent = flag;
    }

    @Nullable
    @NotEmpty
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(@Nullable @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.attributeName = StringSupport.trimOrNull((String)name);
    }

    @Nullable
    @NotEmpty
    public String getAttributeNameFormat() {
        return this.attributeNameFormat;
    }

    public void setAttributeNameFormat(@Nullable @NotEmpty String format) {
        this.checkSetterPreconditions();
        this.attributeNameFormat = StringSupport.trimOrNull((String)format);
        if (this.attributeNameFormat != null && "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified".equals(this.attributeNameFormat)) {
            this.attributeNameFormat = null;
        }
    }

    @Nonnull
    public Set<IdPAttributeValue> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        this.checkComponentActive();
        AttributeConsumingService service = this.getAttributeConsumingService(filterContext);
        if (null == service) {
            if (this.matchIfMetadataSilent) {
                this.log.debug("{} The peer's metadata/request did not contain requested attribute information, returning all the input values", (Object)this.getLogPrefix());
                return CollectionSupport.copyToSet((Collection)attribute.getValues());
            }
            this.log.debug("{} The peer's metadata/request did not contain requested attribute information, returning no values", (Object)this.getLogPrefix());
            return CollectionSupport.emptySet();
        }
        if (this.attributeName != null) {
            String attributeToLog;
            this.log.debug("Looking for RequestedAttribute {} (NameFormat {}) in metadata", (Object)this.attributeName, (Object)this.attributeNameFormat);
            assert (this.attributeName != null);
            RequestedAttribute requestedAttribute = this.findInMetadata(service, this.attributeName, this.attributeNameFormat);
            String string = attributeToLog = this.attributeName != null ? this.attributeName : attribute.getId();
            if (null == requestedAttribute) {
                this.log.debug("{} Attribute {} not found in metadata", (Object)this.getLogPrefix(), (Object)attributeToLog);
                return CollectionSupport.emptySet();
            }
            Boolean isRequired = requestedAttribute.isRequired();
            if (isRequired == null) {
                isRequired = false;
            }
            if (this.onlyIfRequired && !isRequired.booleanValue()) {
                this.log.debug("{} Attribute {} found in metadata, but was not required, values not matched", (Object)this.getLogPrefix(), (Object)attributeToLog);
                return CollectionSupport.emptySet();
            }
            LinkedHashSet<IdPAttributeValue> values = new LinkedHashSet<IdPAttributeValue>();
            values.addAll(this.filterValues(attributeToLog, attribute, requestedAttribute.getAttributeValues()));
            return values;
        }
        Multimap<String, IdPAttribute> requestedAttributes = this.getMappedRequestedAttributes(service);
        if (requestedAttributes == null || requestedAttributes.isEmpty()) {
            this.log.debug("{} No decoded attributes found when filtering", (Object)this.getLogPrefix());
            if (this.matchIfMetadataSilent) {
                this.log.debug("{} The peer's metadata did not contain requested attribute information, returning all the input values", (Object)this.getLogPrefix());
                return CollectionSupport.copyToSet((Collection)attribute.getValues());
            }
            this.log.debug("{} The peer's metadata did not contain requested attribute information, returning no values", (Object)this.getLogPrefix());
            return CollectionSupport.emptySet();
        }
        Collection requestedAttributeList = requestedAttributes.get((Object)attribute.getId());
        if (null == requestedAttributeList) {
            this.log.debug("{} Decoded attribute {} not found in metadata", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return CollectionSupport.emptySet();
        }
        LinkedHashSet<IdPAttributeValue> values = new LinkedHashSet<IdPAttributeValue>();
        for (IdPAttribute requestedAttribute : List.copyOf(requestedAttributeList)) {
            if (requestedAttribute instanceof IdPRequestedAttribute && !((IdPRequestedAttribute)requestedAttribute).isRequired() && this.onlyIfRequired) {
                this.log.debug("{} Decoded attribute {} found in metadata, but not required, values not matched", (Object)this.getLogPrefix(), (Object)attribute.getId());
                continue;
            }
            values.addAll(this.filterValues(attribute, requestedAttribute.getValues()));
        }
        return values;
    }

    @Nullable
    private AttributeConsumingService getAttributeConsumingService(@Nonnull AttributeFilterContext filterContext) {
        SAMLMetadataContext metadataContext = filterContext.getRequesterMetadataContext();
        if (null == metadataContext) {
            this.log.warn("{} No metadata context when filtering", (Object)this.getLogPrefix());
            return null;
        }
        AttributeConsumingServiceContext acsContext = (AttributeConsumingServiceContext)metadataContext.getSubcontext(AttributeConsumingServiceContext.class);
        return acsContext != null ? acsContext.getAttributeConsumingService() : null;
    }

    @Nullable
    private Multimap<String, IdPAttribute> getMappedRequestedAttributes(@Nonnull AttributeConsumingService service) {
        AttributesMapContainer container;
        List containerList = service.getObjectMetadata().get(AttributesMapContainer.class);
        if (null == containerList || containerList.isEmpty()) {
            return null;
        }
        if (containerList.size() > 1) {
            this.log.error("{} More than one set of mapped attributes found when filtering, this shouldn't ever happen", (Object)this.getLogPrefix());
        }
        return (container = (AttributesMapContainer)containerList.get(0)) != null ? container.get() : null;
    }

    @Nullable
    private RequestedAttribute findInMetadata(@Nonnull AttributeConsumingService service, @Nonnull String name, @Nullable String nameFormat) {
        List requested = service.getRequestedAttributes();
        for (RequestedAttribute attr : requested) {
            if (!name.equals(attr.getName())) continue;
            String format = attr.getNameFormat();
            if (nameFormat != null && format != null && !format.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified") && !nameFormat.equals(format)) continue;
            return attr;
        }
        return null;
    }

    @Nonnull
    private Set<IdPAttributeValue> filterValues(@Nonnull IdPAttribute attribute, @Nonnull List<IdPAttributeValue> requestedValues) {
        if (null == requestedValues || requestedValues.isEmpty()) {
            this.log.debug("{} Attribute {} found in metadata and no values specified", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return CollectionSupport.copyToSet((Collection)attribute.getValues());
        }
        Set result = (Set)((NonnullSupplier)attribute.getValues().stream().filter(v -> requestedValues.contains(v)).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
        this.log.debug("{} Values matched with metadata for Attribute {} : {}", new Object[]{this.getLogPrefix(), attribute.getId(), result});
        return result;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    private Set<IdPAttributeValue> filterValues(@Nonnull String attributeToLog, @Nonnull IdPAttribute attribute, @Nonnull List<XMLObject> requestedValues) {
        if (requestedValues.isEmpty()) {
            this.log.debug("{} Attribute {} found in metadata and no values specified", (Object)this.getLogPrefix(), (Object)attributeToLog);
            return CollectionSupport.copyToSet((Collection)attribute.getValues());
        }
        LinkedHashSet<IdPAttributeValue> result = new LinkedHashSet<IdPAttributeValue>(attribute.getValues().size());
        for (IdPAttributeValue attributeValue : attribute.getValues()) {
            if (attributeValue instanceof StringAttributeValue) {
                for (XMLObject xmlObj : requestedValues) {
                    assert (xmlObj != null);
                    if (!this.match(xmlObj, ((StringAttributeValue)attributeValue).getValue())) continue;
                    result.add(attributeValue);
                }
                continue;
            }
            this.log.warn("{} Attribute {} value not a simple string, can't match against values in metadata", (Object)this.getLogPrefix(), (Object)attribute.getId());
        }
        this.log.debug("{} Values matched with metadata for Attribute {} : {}", new Object[]{this.getLogPrefix(), attributeToLog, result});
        return CollectionSupport.copyToSet(result);
    }

    private boolean match(@Nonnull XMLObject xmlObj, @Nonnull String attributeValue) {
        XSAny wc;
        String toMatch = null;
        if (xmlObj instanceof XSString) {
            toMatch = ((XSString)xmlObj).getValue();
        } else if (xmlObj instanceof XSURI) {
            toMatch = ((XSURI)xmlObj).getURI();
        } else if (xmlObj instanceof XSBoolean) {
            Boolean flag;
            XSBooleanValue bval = ((XSBoolean)xmlObj).getValue();
            if (bval != null && (flag = bval.getValue()) != null) {
                toMatch = flag != false ? "1" : "0";
            }
        } else if (xmlObj instanceof XSInteger) {
            Integer ival = ((XSInteger)xmlObj).getValue();
            if (ival != null) {
                toMatch = ival.toString();
            }
        } else if (xmlObj instanceof XSDateTime) {
            Instant dt = ((XSDateTime)xmlObj).getValue();
            if (dt != null) {
                toMatch = DOMTypeSupport.instantToString((Instant)dt);
            }
        } else if (xmlObj instanceof XSBase64Binary) {
            toMatch = ((XSBase64Binary)xmlObj).getValue();
        } else if (xmlObj instanceof XSAny && (wc = (XSAny)xmlObj).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            toMatch = wc.getTextContent();
        }
        if (toMatch != null) {
            return toMatch.equals(attributeValue);
        }
        this.log.warn("Unrecognized XMLObject type, unable to match as a string to candidate value");
        return false;
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Attribute Filter '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        assert (prefix != null);
        return prefix;
    }
}

