/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.filter.matcher.impl.AbstractStringMatcher;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class AttributeValueStringMatcher
extends AbstractStringMatcher {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeValueStringMatcher.class);

    @Override
    public boolean compareAttributeValue(@Nullable IdPAttributeValue value) {
        if (null == value) {
            return false;
        }
        if (value instanceof EmptyAttributeValue) {
            EmptyAttributeValue empty = (EmptyAttributeValue)value;
            switch (empty.getValue()) {
                case NULL_VALUE: {
                    return super.stringCompare(null);
                }
                case ZERO_LENGTH_VALUE: {
                    return super.stringCompare("");
                }
            }
            throw new IllegalArgumentException("Unknown empty attribute value type " + String.valueOf(value.getNativeValue()));
        }
        if (value instanceof StringAttributeValue) {
            StringAttributeValue strval = (StringAttributeValue)value;
            return super.stringCompare(strval.getValue());
        }
        String valueAsString = value.getNativeValue().toString();
        this.log.warn("{} Object supplied to StringAttributeValue comparison was of class {}, not StringAttributeValue, comparing with {}", new Object[]{this.getLogPrefix(), value.getClass().getName(), valueAsString});
        return super.stringCompare(valueAsString);
    }
}

