/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import net.shibboleth.shared.spring.util.SpringSupport;

public abstract class AbstractAttributeDisplayFunction
implements Function<IdPAttribute, String> {
    @Nonnull
    @Unmodifiable
    private final List<Locale.LanguageRange> languageRange;
    @Nonnull
    @Unmodifiable
    private final List<Locale.LanguageRange> defaultLanguageRange;
    @Nonnull
    private Map<IdPAttribute, Map<Locale, String>> cachedInfo = new HashMap<IdPAttribute, Map<Locale, String>>();
    @Nonnull
    private ReloadableService<AttributeTranscoderRegistry> transcoder;

    public AbstractAttributeDisplayFunction(@Nonnull HttpServletRequest request, @Nullable List<String> defaultLanguages, ReloadableService<AttributeTranscoderRegistry> transcoderService) {
        this.languageRange = SpringSupport.getLanguageRange((HttpServletRequest)request);
        this.transcoder = (ReloadableService)Constraint.isNotNull(transcoderService, (String)"Injected transocde service should be non-null");
        this.defaultLanguageRange = defaultLanguages == null || defaultLanguages.isEmpty() ? CollectionSupport.emptyList() : (List)((NonnullSupplier)defaultLanguages.stream().map(StringSupport::trimOrNull).filter(e -> e != null).map(s -> new Locale.LanguageRange((String)s)).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }

    @Override
    @Nullable
    public String apply(@Nullable IdPAttribute input) {
        Locale locale;
        if (input == null) {
            return "N/A";
        }
        Map<Locale, String> displayInfo = this.cachedInfo.get(input);
        if (displayInfo == null) {
            try (ServiceableComponent component = this.transcoder.getServiceableComponent();){
                displayInfo = this.getDisplayInfo((AttributeTranscoderRegistry)component.getComponent(), input);
            }
            catch (ServiceException e) {
                displayInfo = CollectionSupport.emptyMap();
            }
            this.cachedInfo.put(input, displayInfo);
        }
        if ((locale = Locale.lookup(this.languageRange, displayInfo.keySet())) == null) {
            locale = Locale.lookup(this.defaultLanguageRange, displayInfo.keySet());
        }
        if (locale == null) {
            return input.getId();
        }
        String result = displayInfo.get(locale);
        if (result == null) {
            return input.getId();
        }
        return result;
    }

    @Nonnull
    protected abstract Map<Locale, String> getDisplayInfo(@Nonnull AttributeTranscoderRegistry var1, @Nonnull IdPAttribute var2);
}

