/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SaveLogoutContext
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String LOGOUT_CONTEXT_KEY = "net.shibboleth.idp.session.impl.LogoutContext";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SaveLogoutContext.class);
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextLookup = new ChildContextLookup(LogoutContext.class);

    public void setLogoutContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        this.logoutContextLookup = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        LogoutContext logoutContext = this.logoutContextLookup.apply(profileRequestContext);
        if (logoutContext == null) {
            this.log.debug("{} LogoutContext not found in ProfileRequestContext", (Object)this.getLogPrefix());
            return ActionSupport.buildEvent((Object)profileRequestContext, (String)"InvalidProfileContext");
        }
        this.log.debug("{} Saving LogoutContext in HTTP session", (Object)this.getLogPrefix());
        springRequestContext.getExternalContext().getSessionMap().put(LOGOUT_CONTEXT_KEY, (Object)logoutContext);
        return ActionSupport.buildProceedEvent((Object)profileRequestContext);
    }
}

