/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.xmlobject.Scope;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.metadata.resolver.filter.AbstractMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public class ScopeFilter
extends AbstractMetadataFilter {
    @Nonnull
    @NotEmpty
    private static final String GUARD_VALUE = "_EMPTY";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScopeFilter.class);
    @Nonnull
    private final Scope guardObject = (Scope)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Scope.DEFAULT_ELEMENT_NAME).buildObject(Scope.DEFAULT_ELEMENT_NAME);
    private boolean removeExistingScopes;
    @Nonnull
    private Multimap<Predicate<EntityDescriptor>, Scope> applyMap;
    @Nonnull
    private final SAMLObjectBuilder<Extensions> extBuilder;

    public ScopeFilter() {
        this.guardObject.setValue(GUARD_VALUE);
        this.extBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Extensions.DEFAULT_ELEMENT_NAME);
        this.applyMap = ArrayListMultimap.create();
    }

    public void setRemoveExistingScopes(boolean flag) {
        this.checkSetterPreconditions();
        this.removeExistingScopes = flag;
    }

    public void setRules(@Nonnull Map<Predicate<EntityDescriptor>, Collection<Scope>> rules) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(rules, (String)"Rules map cannot be null");
        this.applyMap = ArrayListMultimap.create((int)rules.size(), (int)1);
        for (Map.Entry<Predicate<EntityDescriptor>, Collection<Scope>> entry : rules.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.applyMap.putAll(entry.getKey(), (Iterable)(entry.getValue().isEmpty() ? CollectionSupport.singletonList((Object)this.guardObject) : CollectionSupport.copyToList(entry.getValue())));
        }
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        this.checkComponentActive();
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
        return metadata;
    }

    protected void filterEntityDescriptor(@Nonnull EntityDescriptor descriptor) {
        for (Map.Entry entry : this.applyMap.asMap().entrySet()) {
            Scope scope;
            if (!((Predicate)entry.getKey()).test(descriptor)) continue;
            Extensions exts = descriptor.getExtensions();
            if (this.removeExistingScopes) {
                List scopes;
                if (exts != null && !(scopes = exts.getUnknownXMLObjects(Scope.DEFAULT_ELEMENT_NAME)).isEmpty()) {
                    this.log.debug("Clearing existing entity-level Scope extensions on EntityDescriptor '{}'", (Object)descriptor.getEntityID());
                    scopes.clear();
                }
                for (RoleDescriptor role : descriptor.getRoleDescriptors()) {
                    assert (role != null);
                    this.filterRoleDescriptor(role);
                }
            }
            Iterator iterator = ((Collection)entry.getValue()).iterator();
            while (iterator.hasNext() && !GUARD_VALUE.equals((scope = (Scope)iterator.next()).getValue())) {
                if (exts == null) {
                    exts = (Extensions)this.extBuilder.buildObject();
                    descriptor.setExtensions(exts);
                }
                try {
                    this.log.info("Adding Scope '{}' to EntityDescriptor '{}'", (Object)scope.getValue(), (Object)descriptor.getEntityID());
                    exts.getUnknownXMLObjects(Scope.DEFAULT_ELEMENT_NAME).add(XMLObjectSupport.cloneXMLObject((XMLObject)scope));
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("Error cloning Scope", e);
                }
            }
        }
    }

    protected void filterEntitiesDescriptor(@Nonnull EntitiesDescriptor descriptor) {
        for (EntitiesDescriptor group : descriptor.getEntitiesDescriptors()) {
            assert (group != null);
            this.filterEntitiesDescriptor(group);
        }
        for (EntityDescriptor entity : descriptor.getEntityDescriptors()) {
            assert (entity != null);
            this.filterEntityDescriptor(entity);
        }
    }

    protected void filterRoleDescriptor(@Nonnull RoleDescriptor role) {
        String entityID;
        XMLObject xMLObject = role.getParent();
        if (xMLObject instanceof EntityDescriptor) {
            EntityDescriptor entity = (EntityDescriptor)xMLObject;
            entityID = entity.getEntityID();
        } else {
            entityID = null;
        }
        Extensions exts = role.getExtensions();
        if (exts != null && !exts.getUnknownXMLObjects(Scope.DEFAULT_ELEMENT_NAME).isEmpty()) {
            this.log.debug("Removing existing Scope extensions from {} role in EntityDescriptor '{}'", (Object)role.getElementQName(), (Object)entityID);
            exts.getUnknownXMLObjects(Scope.DEFAULT_ELEMENT_NAME).clear();
        }
    }
}

