/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.plugin;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.plugin.Plugin;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;

public abstract class AbstractPlugin<T extends Module>
implements Plugin<T> {
    @Nonnull
    private Set<T> enableModules;
    @Nonnull
    private Set<T> disableModules;
    @Nonnull
    private List<Plugin.Package> packages = CollectionSupport.emptyList();

    public AbstractPlugin() {
        this.enableModules = CollectionSupport.emptySet();
        this.disableModules = CollectionSupport.emptySet();
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getPluginId() {
        String result = this.getClass().getPackageName();
        assert (result != null);
        return result;
    }

    @Override
    @Nonnegative
    public int getPatchVersion() {
        return 0;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getRequiredModules() {
        return CollectionSupport.emptySet();
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<T> getEnableOnInstall() {
        return this.enableModules;
    }

    @Override
    public String getLicenseFileLocation() {
        return null;
    }

    protected void setEnableOnInstall(@Nonnull Set<T> modules) {
        this.enableModules = CollectionSupport.copyToSet(modules);
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<T> getDisableOnRemoval() {
        return this.disableModules;
    }

    protected void setDisableOnRemoval(@Nonnull Set<T> modules) {
        this.disableModules = CollectionSupport.copyToSet(modules);
    }

    @Override
    @Nonnull
    public Collection<Plugin.Package> getPackages() {
        return this.packages;
    }

    public void setPackages(@Nonnull Collection<Plugin.Package> input) {
        this.packages = CollectionSupport.copyToList(input);
    }

    public boolean equals(Object obj) {
        return obj instanceof Plugin && this.getPluginId().equals(((Plugin)obj).getPluginId());
    }

    public int hashCode() {
        return this.getPluginId().hashCode();
    }

    public String toString() {
        return "Plugin " + this.getPluginId();
    }
}

