/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MovingAverages;
import com.codahale.metrics.SlidingTimeWindowMovingAverages;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.codec.StringDigester;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class LoopDetectionPredicate
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LoopDetectionPredicate.class);
    @Nonnull
    private final MetricRegistry privateRegistry = new MetricRegistry();
    private long threshold = 20L;
    @Nonnull
    private Map<String, String> relyingPartyMap = CollectionSupport.emptyMap();
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, String> tagGenerationStrategy = new DefaultTagGenerator();
    @Nonnull
    private Function<ProfileRequestContext, String> usernameLookupStrategy = FunctionSupport.constant(null);

    public void setThreshold(@Positive long value) {
        this.threshold = Constraint.isGreaterThan((long)0L, (long)value, (String)"Threshold must be positive");
    }

    public void setRelyingPartyMap(@Nullable Map<String, String> map) {
        this.relyingPartyMap = map != null ? CollectionSupport.copyToMap(map) : CollectionSupport.emptyMap();
    }

    public void setUsernameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.usernameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Username lookup strategy cannot be null");
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition cannot be null");
    }

    public void setTagGenerationStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.tagGenerationStrategy = (Function)Constraint.isNotNull(strategy, (String)"Tag generation function cannot be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        String username = this.usernameLookupStrategy.apply(input);
        RelyingPartyContext rpCtx = this.getRelyingPartyContextLookupStrategy().apply(input);
        if (username != null && rpCtx != null && rpCtx.getRelyingPartyId() != null) {
            String meterName = this.relyingPartyMap.get(rpCtx.getRelyingPartyId());
            if (meterName == null && this.activationCondition.test(input)) {
                meterName = this.tagGenerationStrategy.apply(input);
            }
            if (meterName != null) {
                try {
                    meterName = MetricRegistry.name((String)"net.shibboleth.idp.loopDetection", (String[])new String[]{meterName, username.replace(".", "")});
                    Meter meter = this.privateRegistry.meter(meterName, (MetricRegistry.MetricSupplier)new MetricRegistry.MetricSupplier<Meter>(){

                        public Meter newMetric() {
                            return new Meter((MovingAverages)new SlidingTimeWindowMovingAverages());
                        }
                    });
                    meter.mark();
                    double rate = meter.getOneMinuteRate();
                    if (rate > (double)this.threshold) {
                        this.log.warn("Meter {} rate of {} exceeded threshold of {}", new Object[]{meterName, rate, this.threshold});
                        this.privateRegistry.remove(meterName);
                        return true;
                    }
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Error manipulating private MetricRegistry", (Throwable)e);
                }
            }
        }
        return false;
    }

    private class DefaultTagGenerator
    implements Function<ProfileRequestContext, String> {
        @Nonnull
        private final StringDigester digester = new StringDigester("SHA1", StringDigester.OutputFormat.HEX_LOWER);

        @Override
        @Nullable
        public String apply(@Nullable ProfileRequestContext input) {
            RelyingPartyContext rpCtx = LoopDetectionPredicate.this.getRelyingPartyContextLookupStrategy().apply(input);
            if (rpCtx != null && rpCtx.getRelyingPartyId() != null) {
                return this.digester.apply(rpCtx.getRelyingPartyId());
            }
            return null;
        }
    }
}

