/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.config.navigate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.config.navigate.AbstractDefaultSecurityConfigurationLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.security.x509.tls.ClientTLSValidationConfiguration;

public class ClientTLSValidationConfigurationLookupFunction
extends AbstractDefaultSecurityConfigurationLookupFunction<List<ClientTLSValidationConfiguration>> {
    @Nullable
    @Live
    public List<ClientTLSValidationConfiguration> apply(@Nullable ProfileRequestContext input) {
        ArrayList<ClientTLSValidationConfiguration> configs = new ArrayList<ClientTLSValidationConfiguration>();
        RelyingPartyContext rpc = this.getRelyingPartyContext(input);
        if (rpc != null) {
            SecurityConfiguration defaultConfig;
            SecurityConfiguration sc;
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && (sc = pc.getSecurityConfiguration(input)) != null && sc.getClientTLSValidationConfiguration() != null) {
                configs.add(sc.getClientTLSValidationConfiguration());
            }
            if ((defaultConfig = this.getDefaultSecurityConfiguration(rpc.getConfiguration(), input)) != null && defaultConfig.getClientTLSValidationConfiguration() != null) {
                configs.add(defaultConfig.getClientTLSValidationConfiguration());
            }
        }
        configs.add((ClientTLSValidationConfiguration)ConfigurationService.get(ClientTLSValidationConfiguration.class));
        return configs;
    }
}

