/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.github.jasminb.jsonapi.ReflectionUtils;
import com.github.jasminb.jsonapi.ResourceIdHandler;
import com.github.jasminb.jsonapi.annotations.Id;
import com.github.jasminb.jsonapi.annotations.Links;
import com.github.jasminb.jsonapi.annotations.Meta;
import com.github.jasminb.jsonapi.annotations.Relationship;
import com.github.jasminb.jsonapi.annotations.RelationshipLinks;
import com.github.jasminb.jsonapi.annotations.RelationshipMeta;
import com.github.jasminb.jsonapi.annotations.Type;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConverterConfiguration {
    private final Map<String, Class<?>> typeToClassMapping = new HashMap();
    private final Map<Class<?>, Type> typeAnnotations = new HashMap();
    private final Map<Class<?>, Field> idMap = new HashMap();
    private final Map<Class<?>, ResourceIdHandler> idHandlerMap = new HashMap();
    private final Map<Class<?>, List<Field>> relationshipMap = new HashMap();
    private final Map<Class<?>, Map<String, Class<?>>> relationshipTypeMap = new HashMap();
    private final Map<Class<?>, Map<String, Field>> relationshipFieldMap = new HashMap();
    private final Map<Field, Relationship> fieldRelationshipMap = new HashMap<Field, Relationship>();
    private final Map<Field, RelationshipMeta> fieldRelationshipMetaMap = new HashMap<Field, RelationshipMeta>();
    private final Map<Class<?>, Map<String, Class<?>>> relationshipMetaTypeMap = new HashMap();
    private final Map<Class<?>, Map<String, Field>> relationshipMetaFieldMap = new HashMap();
    private final Map<Class<?>, Class<?>> metaTypeMap = new HashMap();
    private final Map<Class<?>, Field> metaFieldMap = new HashMap();
    private final Map<Class<?>, Field> linkFieldMap = new HashMap();
    private final Map<Class<?>, Map<String, Field>> relationshipLinksFieldMap = new HashMap();

    public ConverterConfiguration(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.registerType(clazz);
        }
    }

    private void processClass(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Type.class)) {
            Type annotation = clazz.getAnnotation(Type.class);
            this.typeToClassMapping.put(annotation.value(), clazz);
            this.typeAnnotations.put(clazz, annotation);
            this.relationshipTypeMap.put(clazz, new HashMap());
            this.relationshipFieldMap.put(clazz, new HashMap());
            this.relationshipMetaFieldMap.put(clazz, new HashMap());
            this.relationshipMetaTypeMap.put(clazz, new HashMap());
            this.relationshipLinksFieldMap.put(clazz, new HashMap());
            List<Field> relationshipFields = ReflectionUtils.getAnnotatedFields(clazz, Relationship.class, true);
            for (Field field : relationshipFields) {
                field.setAccessible(true);
                Relationship relationship = field.getAnnotation(Relationship.class);
                Class<?> targetType = ReflectionUtils.getFieldType(field);
                this.relationshipTypeMap.get(clazz).put(relationship.value(), targetType);
                this.relationshipFieldMap.get(clazz).put(relationship.value(), field);
                this.fieldRelationshipMap.put(field, relationship);
                if (relationship.resolve() && relationship.relType() == null) {
                    throw new IllegalArgumentException("@Relationship on " + clazz.getName() + "#" + field.getName() + " with 'resolve = true' must have a relType attribute set.");
                }
                this.registerType(targetType);
            }
            this.relationshipMap.put(clazz, relationshipFields);
            List<Field> relMetaFields = ReflectionUtils.getAnnotatedFields(clazz, RelationshipMeta.class, true);
            for (Field field : relMetaFields) {
                field.setAccessible(true);
                RelationshipMeta relationshipMeta = field.getAnnotation(RelationshipMeta.class);
                Class<?> targetType = ReflectionUtils.getFieldType(field);
                this.relationshipMetaTypeMap.get(clazz).put(relationshipMeta.value(), targetType);
                this.fieldRelationshipMetaMap.put(field, relationshipMeta);
                this.relationshipMetaFieldMap.get(clazz).put(relationshipMeta.value(), field);
            }
            List<Field> list = ReflectionUtils.getAnnotatedFields(clazz, RelationshipLinks.class, true);
            for (Field relLinkField : list) {
                relLinkField.setAccessible(true);
                RelationshipLinks links = relLinkField.getAnnotation(RelationshipLinks.class);
                this.relationshipLinksFieldMap.get(clazz).put(links.value(), relLinkField);
            }
            List<Field> list2 = ReflectionUtils.getAnnotatedFields(clazz, Id.class, true);
            if (!list2.isEmpty() && list2.size() == 1) {
                Field idField = list2.get(0);
                idField.setAccessible(true);
                this.idMap.put(clazz, idField);
                try {
                    this.idHandlerMap.put(clazz, idField.getAnnotation(Id.class).value().newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException("Unable to construct handler instance by using no-arg constructor", e);
                }
            } else {
                if (list2.isEmpty()) {
                    throw new IllegalArgumentException("All resource classes must have a field annotated with the @Id annotation");
                }
                throw new IllegalArgumentException("Only single @Id annotation is allowed per defined type!");
            }
            List<Field> metaFields = ReflectionUtils.getAnnotatedFields(clazz, Meta.class, true);
            if (metaFields.size() == 1) {
                Field metaField = metaFields.get(0);
                metaField.setAccessible(true);
                Class<?> metaType = ReflectionUtils.getFieldType(metaField);
                this.metaTypeMap.put(clazz, metaType);
                this.metaFieldMap.put(clazz, metaField);
            } else if (metaFields.size() > 1) {
                throw new IllegalArgumentException(String.format("Only one meta field is allowed for type '%s'", clazz.getCanonicalName()));
            }
            List<Field> linkFields = ReflectionUtils.getAnnotatedFields(clazz, Links.class, true);
            if (linkFields.size() == 1) {
                Field linkField = linkFields.get(0);
                linkField.setAccessible(true);
                Class<?> metaType = ReflectionUtils.getFieldType(linkField);
                if (!com.github.jasminb.jsonapi.Links.class.isAssignableFrom(metaType)) {
                    throw new IllegalArgumentException(String.format("%s is not allowed to be used as @Links attribute. Only com.github.jasminb.jsonapi.Links or its derivatives can be annotated as @Links", metaType.getCanonicalName()));
                }
                this.linkFieldMap.put(clazz, linkField);
            } else if (linkFields.size() > 1) {
                throw new IllegalArgumentException(String.format("Only one links field is allowed for type '%s'", clazz.getCanonicalName()));
            }
        } else if (!clazz.isInterface()) {
            throw new IllegalArgumentException(String.format("Class %s doesn't have a Type annotation. All resource classes must be annotated with a Type annotation!", clazz.getName()));
        }
    }

    public Field getMetaField(Class<?> clazz) {
        return this.metaFieldMap.get(clazz);
    }

    public Class<?> getMetaType(Class<?> clazz) {
        return this.metaTypeMap.get(clazz);
    }

    public Field getLinksField(Class<?> clazz) {
        return this.linkFieldMap.get(clazz);
    }

    public Class<?> getTypeClass(String typeName) {
        return this.typeToClassMapping.get(typeName);
    }

    public Field getIdField(Class<?> clazz) {
        return this.idMap.get(clazz);
    }

    public ResourceIdHandler getIdHandler(Class<?> clazz) {
        return this.idHandlerMap.get(clazz);
    }

    public Field getRelationshipField(Class<?> clazz, String fieldName) {
        return this.relationshipFieldMap.get(clazz).get(fieldName);
    }

    public Class<?> getRelationshipType(Class<?> clazz, String fieldName) {
        return this.relationshipTypeMap.get(clazz).get(fieldName);
    }

    public Relationship getFieldRelationship(Field field) {
        return this.fieldRelationshipMap.get(field);
    }

    public List<Field> getRelationshipFields(Class<?> clazz) {
        return this.relationshipMap.get(clazz);
    }

    public boolean isRegisteredType(Class<?> clazz) {
        return this.typeAnnotations.containsKey(clazz);
    }

    public String getTypeName(Class<?> clazz) {
        Type type = this.typeAnnotations.get(clazz);
        if (type != null) {
            return type.value();
        }
        return null;
    }

    public Type getType(Class<?> clazz) {
        return this.typeAnnotations.get(clazz);
    }

    public synchronized boolean registerType(Class<?> type) {
        if (!this.isRegisteredType(type)) {
            this.processClass(type);
            return true;
        }
        return false;
    }

    public static boolean isEligibleType(Class<?> type) {
        return type.isAnnotationPresent(Type.class) && !ReflectionUtils.getAnnotatedFields(type, Id.class, true).isEmpty();
    }

    public Field getRelationshipMetaField(Class<?> clazz, String relationshipName) {
        return this.relationshipMetaFieldMap.get(clazz).get(relationshipName);
    }

    public Class<?> getRelationshipMetaType(Class<?> clazz, String relationshipName) {
        return this.relationshipMetaTypeMap.get(clazz).get(relationshipName);
    }

    public Field getRelationshipLinksField(Class<?> clazz, String relationshipName) {
        return this.relationshipLinksFieldMap.get(clazz).get(relationshipName);
    }
}

